/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.lang.reflect.Array;
import java.util.Vector;
import org.knowceans.util.ArrayUtils;
import org.knowceans.util.DoubleFormat;

public class Vectors {
    protected static int ndigits = 0;
    protected static int colwidth = 0;

    public static final void setFormat(int colwidth, int ndigits) {
        Vectors.colwidth = colwidth;
        Vectors.ndigits = ndigits;
    }

    public static final int[] getFormat() {
        return new int[]{colwidth, ndigits};
    }

    public static final void unsetFormat() {
        colwidth = 0;
        ndigits = 0;
    }

    public static int[] range(int start, int end, int step) {
        int[] out = new int[(int)Math.floor((end - start) / step) + 1];
        int i = 0;
        while (i < out.length) {
            out[i] = start + step * i;
            ++i;
        }
        return out;
    }

    public static int[] range(int start, int end) {
        return Vectors.range(start, end, end - start > 0 ? 1 : -1);
    }

    public static double[] range(double start, double end, double step) {
        double[] out = new double[(int)Math.floor((end - start) / step) + 1];
        int i = 0;
        while (i < out.length) {
            out[i] = start + step * (double)i;
            ++i;
        }
        return out;
    }

    public static double[] range(double start, double end) {
        return Vectors.range(start, end, (double)(end - start > 0.0 ? 1 : -1));
    }

    public static double sum(double[] vec) {
        double sum = 0.0;
        int i = 0;
        while (i < vec.length) {
            sum += vec[i];
            ++i;
        }
        return sum;
    }

    public static double product(double[] vec) {
        double prod = 1.0;
        int i = 0;
        while (i < vec.length) {
            prod *= vec[i];
            ++i;
        }
        return prod;
    }

    public static double sum(float[] vec) {
        double sum = 0.0;
        int i = 0;
        while (i < vec.length) {
            sum += (double)vec[i];
            ++i;
        }
        return sum;
    }

    public static int sum(int[] vec) {
        int sum = 0;
        int i = 0;
        while (i < vec.length) {
            sum += vec[i];
            ++i;
        }
        return sum;
    }

    public static double[] cumsum(double[] vec) {
        double[] x = new double[vec.length];
        x[0] = vec[0];
        int i = 1;
        while (i < vec.length) {
            x[i] = vec[i] + x[i - 1];
            ++i;
        }
        return x;
    }

    public static float[] cumsum(float[] vec) {
        float[] x = new float[vec.length];
        x[0] = vec[0];
        int i = 1;
        while (i < vec.length) {
            x[i] = vec[i] + x[i - 1];
            ++i;
        }
        return x;
    }

    public static int max(int[] vec) {
        int max = vec[0];
        int i = 1;
        while (i < vec.length) {
            if (vec[i] > max) {
                max = vec[i];
            }
            ++i;
        }
        return max;
    }

    public static double max(double[] vec) {
        double max = vec[0];
        int i = 1;
        while (i < vec.length) {
            if (vec[i] > max) {
                max = vec[i];
            }
            ++i;
        }
        return max;
    }

    public static double max(float[] vec) {
        float max = vec[0];
        int i = 1;
        while (i < vec.length) {
            if (vec[i] > max) {
                max = vec[i];
            }
            ++i;
        }
        return max;
    }

    public static int min(int[] vec) {
        int min = vec[0];
        int i = 1;
        while (i < vec.length) {
            if (vec[i] < min) {
                min = vec[i];
            }
            ++i;
        }
        return min;
    }

    public static double min(double[] vec) {
        double min = vec[0];
        int i = 1;
        while (i < vec.length) {
            if (vec[i] < min) {
                min = vec[i];
            }
            ++i;
        }
        return min;
    }

    public static float min(float[] vec) {
        float min = vec[0];
        int i = 1;
        while (i < vec.length) {
            if (vec[i] < min) {
                min = vec[i];
            }
            ++i;
        }
        return min;
    }

    public static int[][] round(double[][] x) {
        int[][] y = new int[x.length][];
        int i = 0;
        while (i < y.length) {
            y[i] = Vectors.round(x[i]);
            ++i;
        }
        return y;
    }

    public static int[][] round(float[][] x) {
        int[][] y = new int[x.length][];
        int i = 0;
        while (i < y.length) {
            y[i] = Vectors.round(x[i]);
            ++i;
        }
        return y;
    }

    public static int[] round(double[] x) {
        int[] y = new int[x.length];
        int i = 0;
        while (i < y.length) {
            y[i] = (int)Math.round(x[i]);
            ++i;
        }
        return y;
    }

    public static int[] round(float[] x) {
        int[] y = new int[x.length];
        int i = 0;
        while (i < y.length) {
            y[i] = Math.round(x[i]);
            ++i;
        }
        return y;
    }

    public static double[] concat(double[] x, double[] y) {
        double[] z = new double[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    public static int[] concat(int[] x, int[] y) {
        int[] z = new int[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    public static double[][] concat(double[][] x, double[] y, boolean rowwise) {
        if (rowwise) {
            double[][] a = new double[1][];
            a[1] = y;
            x = Vectors.concat(x, a, true);
            return x;
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("[x; y] needs x and y to have equal column dimensions.");
        }
        double[][] z = new double[x.length][];
        int i = 0;
        while (i < x.length) {
            z[i] = new double[x[i].length + y.length];
            z[i][z[i].length - 1] = y[i];
            System.arraycopy(x[i], 0, z[i], 0, x[i].length);
            ++i;
        }
        return z;
    }

    public static double[][] concat(double[][] x, double[][] y, boolean rowwise) {
        if (rowwise) {
            double[][] z = new double[x.length + y.length][];
            System.arraycopy(x, 0, z, 0, x.length);
            System.arraycopy(y, 0, z, x.length, y.length);
            return z;
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("[x; y] needs x and y to have equal column dimensions.");
        }
        double[][] z = new double[x.length][];
        int i = 0;
        while (i < x.length) {
            z[i] = new double[x[i].length + y[i].length];
            System.arraycopy(x[i], 0, z[i], 0, x[i].length);
            System.arraycopy(y[i], 0, z[i], x[i].length, y[i].length);
            ++i;
        }
        return z;
    }

    public static int[][] concat(int[][] x, int[][] y, boolean rowwise) {
        if (rowwise) {
            int[][] z = new int[x.length + y.length][];
            System.arraycopy(x, 0, z, 0, x.length);
            System.arraycopy(y, 0, z, x.length, y.length);
            return z;
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("[x; y] needs x and y to have equal column dimensions.");
        }
        int[][] z = new int[x.length][];
        int i = 0;
        while (i < x.length) {
            z[i] = new int[x[i].length + y[i].length];
            System.arraycopy(x[i], 0, z[i], 0, x[i].length);
            System.arraycopy(y[i], 0, z[i], x[i].length, y[i].length);
            ++i;
        }
        return z;
    }

    public static double[][] repmat(double[][] a, int rows, int cols) {
        double[][] b = (double[][])ArrayUtils.copy(a);
        int i = 0;
        while (i < cols) {
            b = Vectors.concat(b, a, false);
            ++i;
        }
        double[][] c = (double[][])ArrayUtils.copy(b);
        int i2 = 0;
        while (i2 < rows) {
            c = Vectors.concat(c, b, true);
            ++i2;
        }
        return c;
    }

    public static int[][] repmat(int[][] a, int rows, int cols) {
        int[][] b = (int[][])ArrayUtils.copy(a);
        int i = 0;
        while (i < cols) {
            b = Vectors.concat(b, a, false);
            ++i;
        }
        int[][] c = (int[][])ArrayUtils.copy(b);
        int i2 = 0;
        while (i2 < rows) {
            c = Vectors.concat(c, b, true);
            ++i2;
        }
        return c;
    }

    public static double[] concat(double[] x, double[] y, double[] z) {
        double[] w = new double[x.length + y.length + z.length];
        System.arraycopy(x, 0, w, 0, x.length);
        System.arraycopy(y, 0, w, x.length, y.length);
        System.arraycopy(y, 0, w, x.length + y.length, z.length);
        return w;
    }

    public static double[] increaseSize(double[] vector, int moreelements) {
        double[] longer = new double[vector.length + moreelements];
        System.arraycopy(vector, 0, longer, 0, vector.length);
        return longer;
    }

    public static double[][] increaseSize(double[][] matrix, int morerows, int morecols) {
        double[][] array2 = new double[matrix.length + morerows][];
        int i = 0;
        while (i < matrix.length) {
            array2[i] = morecols > 0 ? Vectors.increaseSize(matrix[i], morecols) : matrix[i];
            ++i;
        }
        i = matrix.length;
        while (i < array2.length) {
            array2[i] = new double[matrix[0].length + morecols];
            ++i;
        }
        return array2;
    }

    public static double[] removeElement(double[] vector, int element) {
        double[] shorter = new double[vector.length - 1];
        System.arraycopy(vector, 0, shorter, 0, element);
        System.arraycopy(vector, element + 1, shorter, element, vector.length - element - 1);
        return shorter;
    }

    public static double[][] removeElements(double[][] matrix, int[] rows, int[] cols) {
        return Vectors.chooseElements(matrix, Vectors.rangeComplement(rows, matrix.length), Vectors.rangeComplement(cols, matrix[0].length));
    }

    public static double[] removeElements(double[] vector, int[] elements) {
        return Vectors.chooseElements(vector, Vectors.rangeComplement(elements, vector.length));
    }

    public static int[] rangeComplement(int[] set, int length) {
        int[] complement = new int[length - set.length];
        int sindex = 0;
        int cindex = 0;
        int i = 0;
        while (i < length) {
            if (sindex >= set.length || set[sindex] != i) {
                complement[cindex] = i;
                ++cindex;
            } else {
                ++sindex;
            }
            ++i;
        }
        return complement;
    }

    public static int[] getColumn(int[][] matrix, int col) {
        int[] a = new int[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            a[i] = matrix[i][col];
            ++i;
        }
        return a;
    }

    public static double[] getColumn(double[][] matrix, int col) {
        double[] a = new double[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            a[i] = matrix[i][col];
            ++i;
        }
        return a;
    }

    public static double[][] chooseElements(double[][] matrix, int[] rows, int[] cols) {
        double[][] matrix2 = new double[rows.length][cols.length];
        int i = 0;
        while (i < rows.length) {
            matrix2[i] = Vectors.chooseElements(matrix[rows[i]], cols);
            ++i;
        }
        return matrix2;
    }

    public static double[] chooseElements(double[] vector, int[] keep) {
        double[] vector2 = new double[keep.length];
        int i = 0;
        while (i < keep.length) {
            vector2[i] = vector[keep[i]];
            ++i;
        }
        return vector2;
    }

    public static double[] chooseColumn(double[][] matrix, int col) {
        double[] column = new double[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            column[i] = matrix[i][col];
            ++i;
        }
        return column;
    }

    public static int[] increaseSize(int[] vector, int moreelements) {
        int[] longer = new int[vector.length + moreelements];
        System.arraycopy(vector, 0, longer, 0, vector.length);
        return longer;
    }

    public static int[][] increaseSize(int[][] matrix, int morerows, int morecols) {
        int[][] array2 = new int[matrix.length + morerows][];
        int i = 0;
        while (i < matrix.length) {
            array2[i] = morecols > 0 ? Vectors.increaseSize(matrix[i], morecols) : matrix[i];
            ++i;
        }
        i = matrix.length;
        while (i < array2.length) {
            array2[i] = new int[matrix[0].length + morecols];
            ++i;
        }
        return array2;
    }

    public static int[] removeElement(int[] vector, int element) {
        int[] shorter = new int[vector.length - 1];
        System.arraycopy(vector, 0, shorter, 0, element);
        System.arraycopy(vector, element + 1, shorter, element, vector.length - element - 1);
        return shorter;
    }

    public static int[][] removeElements(int[][] matrix, int[] rows, int[] cols) {
        return Vectors.chooseElements(matrix, Vectors.rangeComplement(rows, matrix.length), Vectors.rangeComplement(cols, matrix[0].length));
    }

    public static int[] removeElements(int[] vector, int[] elements) {
        return Vectors.chooseElements(vector, Vectors.rangeComplement(elements, vector.length));
    }

    public static int[][] chooseElements(int[][] matrix, int[] rows, int[] cols) {
        int[][] matrix2 = new int[rows.length][cols.length];
        int i = 0;
        while (i < rows.length) {
            matrix2[i] = Vectors.chooseElements(matrix[rows[i]], cols);
            ++i;
        }
        return matrix2;
    }

    public static int[][] chooseElements(int[][] matrix, int[] rows) {
        int[][] matrix2 = new int[rows.length][];
        int i = 0;
        while (i < rows.length) {
            matrix2[i] = matrix[rows[i]];
            ++i;
        }
        return matrix2;
    }

    public static int[] chooseElements(int[] vector, int[] keep) {
        int[] vector2 = new int[keep.length];
        int i = 0;
        while (i < keep.length) {
            vector2[i] = vector[keep[i]];
            ++i;
        }
        return vector2;
    }

    public static String print(double[] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(Vectors.format(x[i])).append(" ");
            ++i;
        }
        if (x.length > 0) {
            b.append(Vectors.format(x[x.length - 1]));
        }
        return b.toString();
    }

    public static String print(float[] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(Vectors.format(x[i])).append(" ");
            ++i;
        }
        if (x.length > 0) {
            b.append(Vectors.format(x[x.length - 1]));
        }
        return b.toString();
    }

    public static String print(Object x) {
        if (x instanceof Object[]) {
            return Vectors.print((Object[])x);
        }
        if (x instanceof int[]) {
            return Vectors.print((int[])x);
        }
        if (x instanceof double[]) {
            return Vectors.print((double[])x);
        }
        if (x instanceof float[]) {
            return Vectors.print((float[])x);
        }
        return null;
    }

    public static String print(Object[] x) {
        return Vectors.print(x, " ");
    }

    public static String print(Object[] x, String delim) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(x[i]).append(delim);
            ++i;
        }
        if (x.length > 0) {
            b.append(x[x.length - 1]);
        }
        return b.toString();
    }

    public static <T> String printf(T x, String format, String delim) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int len = Array.getLength(x);
        int i = 0;
        while (i < Array.getLength(x) - 1) {
            b.append(String.format(format, Array.get(x, i))).append(delim);
            ++i;
        }
        if (len > 0) {
            b.append(String.format(format, Array.get(x, len - 1)));
        }
        return b.toString();
    }

    private static String format(double x) {
        if (ndigits > 0) {
            return DoubleFormat.format(x, ndigits, colwidth);
        }
        return Double.toString(x);
    }

    public static String print(double[][] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(Vectors.print(x[i])).append("\n");
            ++i;
        }
        if (x.length > 0) {
            b.append(Vectors.print(x[x.length - 1]));
        }
        return b.toString();
    }

    public static String print(float[][] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(Vectors.print(x[i])).append("\n");
            ++i;
        }
        if (x.length > 0) {
            b.append(Vectors.print(x[x.length - 1]));
        }
        return b.toString();
    }

    public static String print(int[] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(x[i]).append(" ");
            ++i;
        }
        if (x.length > 0) {
            b.append(x[x.length - 1]);
        }
        return b.toString();
    }

    public static String print(int[][] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(Vectors.print(x[i])).append("\n");
            ++i;
        }
        if (x.length > 0) {
            b.append(Vectors.print(x[x.length - 1]));
        }
        return b.toString();
    }

    public static String print(int[][] x, String delim) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < x.length - 1) {
            b.append(Vectors.print(x[i])).append(delim);
            ++i;
        }
        if (x.length > 0) {
            b.append(Vectors.print(x[x.length - 1]));
        }
        return b.toString();
    }

    public static double[] ones(int len, double factor) {
        double[] x = new double[len];
        int i = 0;
        while (i < x.length) {
            x[i] = factor;
            ++i;
        }
        return x;
    }

    public static int[] ones(int len, int factor) {
        int[] x = new int[len];
        int i = 0;
        while (i < x.length) {
            x[i] = factor;
            ++i;
        }
        return x;
    }

    public static double[] zeros(int len) {
        return new double[len];
    }

    public static int[] ones(int len) {
        return Vectors.ones(len, 1);
    }

    public static int[] cast(double[] vec) {
        int[] ivec = new int[vec.length];
        int i = 0;
        while (i < ivec.length) {
            ivec[i] = (int)vec[i];
            ++i;
        }
        return ivec;
    }

    public static double[] cast(int[] vec) {
        double[] dvec = new double[vec.length];
        int i = 0;
        while (i < dvec.length) {
            dvec[i] = vec[i];
            ++i;
        }
        return dvec;
    }

    public static int[] find(int[] vec, int val) {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < vec.length) {
            if (vec[i] == val) {
                v.add(new Integer(i));
            }
            ++i;
        }
        int[] vv = new int[v.size()];
        int i2 = 0;
        while (i2 < vv.length) {
            vv[i2] = (Integer)v.get(i2);
            ++i2;
        }
        return vv;
    }

    public static double[] subVector(double[] vec, int[] indices) {
        double[] x = new double[indices.length];
        int i = 0;
        while (i < x.length) {
            x[i] = vec[indices[i]];
            ++i;
        }
        return x;
    }

    public static int[] subVector(int[] vec, int[] indices) {
        int[] x = new int[indices.length];
        int i = 0;
        while (i < x.length) {
            x[i] = vec[indices[i]];
            ++i;
        }
        return x;
    }

    public static double[] subVector(double[] vec, int start, int end) {
        double[] x = new double[end - start + 1];
        int i = 0;
        while (i <= end - start) {
            x[i] = vec[start + i];
            ++i;
        }
        return x;
    }

    public static double[] sub(double[] vec, int start, int length) {
        double[] x = new double[length];
        int i = 0;
        while (i < length) {
            x[i] = vec[start + i];
            ++i;
        }
        return x;
    }

    public static int[] sub(int[] vec, int start, int length) {
        int[] x = new int[length];
        int i = 0;
        while (i < length) {
            x[i] = vec[start + i];
            ++i;
        }
        return x;
    }

    public static void setSubVector(int[] vec, int[] indices, int[] replacements) {
        int i = 0;
        while (i < indices.length) {
            vec[indices[i]] = replacements[i];
            ++i;
        }
    }

    public static void setSubVector(int[] vec, int[] indices, int replacement) {
        int i = 0;
        while (i < indices.length) {
            vec[indices[i]] = replacement;
            ++i;
        }
    }

    public static void add(int[] vec, int scalar) {
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] + scalar;
        }
    }

    public static double[] add(int[] vec, double scalar) {
        double[] aa = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            aa[i] = scalar + (double)vec[i];
            ++i;
        }
        return aa;
    }

    public static void add(double[][] mat, double scalar) {
        int i = 0;
        while (i < mat.length) {
            Vectors.add(mat[i], scalar);
            ++i;
        }
    }

    public static void add(double[] vec, double scalar) {
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] + scalar;
        }
    }

    public static void add(double[] a, int[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] + (double)b[i];
            ++i;
        }
    }

    public static void add(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] + b[i];
            ++i;
        }
    }

    public static void add(int[] a, int[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] + b[i];
            ++i;
        }
    }

    public static void subtract(int[] a, int[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] - b[i];
            ++i;
        }
    }

    public static void subtract(double[] a, int[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] - (double)b[i];
            ++i;
        }
    }

    public static void subtract(int[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = (int)((double)a[n] - b[i]);
            ++i;
        }
    }

    public static void subtract(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] - b[i];
            ++i;
        }
    }

    public static double sqdist(double[] a, double[] b) {
        double dist = 0.0;
        int i = 0;
        while (i < a.length) {
            double diff = a[i] - b[i];
            dist += diff * diff;
            ++i;
        }
        return dist;
    }

    public static double sqabs(double[] a) {
        double mag = 0.0;
        int i = 0;
        while (i < a.length) {
            mag += a[i] * a[i];
            ++i;
        }
        return mag;
    }

    public static int[] setSubVectorCopy(int[] vec, int[] indices, int[] replacements) {
        int[] x = new int[vec.length];
        int i = 0;
        while (i < indices.length) {
            x[indices[i]] = replacements[i];
            ++i;
        }
        return x;
    }

    public static Object copy(Object source) {
        if (source instanceof double[]) {
            return Vectors.copy((double[])source);
        }
        if (source instanceof float[]) {
            return Vectors.copy((float[])source);
        }
        if (source instanceof int[]) {
            return Vectors.copy((int[])source);
        }
        return null;
    }

    public static double[] copy(double[] source) {
        if (source == null) {
            return null;
        }
        double[] dest = new double[source.length];
        int i = 0;
        while (i < dest.length) {
            dest[i] = source[i];
            ++i;
        }
        return dest;
    }

    public static float[] copy(float[] source) {
        if (source == null) {
            return null;
        }
        float[] dest = new float[source.length];
        int i = 0;
        while (i < dest.length) {
            dest[i] = source[i];
            ++i;
        }
        return dest;
    }

    public static int[] copy(int[] source) {
        if (source == null) {
            return null;
        }
        int[] dest = new int[source.length];
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static double[] copyDouble(int[] source) {
        if (source == null) {
            return null;
        }
        double[] dest = new double[source.length];
        int i = 0;
        while (i < source.length) {
            dest[i] = source[i];
            ++i;
        }
        return dest;
    }

    public static void copy(int[] source, double[] dest) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < source.length) {
            dest[i] = source[i];
            ++i;
        }
    }

    public static void copy(double[] source, int[] dest) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < source.length) {
            dest[i] = (int)source[i];
            ++i;
        }
    }

    public static void copy(int[] source, int[] dest) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < source.length) {
            dest[i] = source[i];
            ++i;
        }
    }

    public static void copy(double[] source, double[] dest) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < source.length) {
            dest[i] = source[i];
            ++i;
        }
    }

    public static void mult(double[] ds, double d) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * d;
        }
    }

    public static void dotmult(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] * b[i];
            ++i;
        }
    }

    public static double mult(double[] ds, double[] dt) {
        if (ds.length != dt.length) {
            throw new IllegalArgumentException("Vector dimensions must agree.");
        }
        double s = 0.0;
        int i = 0;
        while (i < ds.length) {
            s += ds[i] * dt[i];
            ++i;
        }
        return s;
    }

    public static double[][] transpose(double[][] mat) {
        double[][] a = new double[mat[0].length][mat.length];
        int i = 0;
        while (i < mat[0].length) {
            int j = 0;
            while (j < mat.length) {
                a[i][j] = mat[j][i];
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static int[][] transpose(int[][] mat) {
        int[][] a = new int[mat[0].length][mat.length];
        int i = 0;
        while (i < mat[0].length) {
            int j = 0;
            while (j < mat.length) {
                a[i][j] = mat[j][i];
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static boolean isDegenerate(double alpha) {
        return Double.isInfinite(alpha) || Double.isNaN(alpha);
    }

    public static boolean isDegenerate(double[] ds) {
        int i = 0;
        while (i < ds.length) {
            if (Vectors.isDegenerate(ds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDegenerate(double[][] pp) {
        int i = 0;
        while (i < pp.length) {
            if (Vectors.isDegenerate(pp[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> boolean isPositive(T ds) {
        if (ds instanceof double[][]) {
            return Vectors.isPositive((double[][])ds);
        }
        if (ds instanceof float[][]) {
            return Vectors.isPositive((float[][])ds);
        }
        if (ds instanceof int[][]) {
            return Vectors.isPositive((int[][])ds);
        }
        if (ds instanceof double[]) {
            return Vectors.isPositive((double[])ds);
        }
        if (ds instanceof float[]) {
            return Vectors.isPositive((float[])ds);
        }
        return Vectors.isPositive((int[])ds);
    }

    public static boolean isPositive(double[] ds) {
        int i = 0;
        while (i < ds.length) {
            if (ds[i] > 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPositive(double[][] pp) {
        int i = 0;
        while (i < pp.length) {
            if (Vectors.isPositive(pp[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> boolean isNegative(T ds) {
        if (ds instanceof double[][]) {
            return Vectors.isNegative((double[][])ds);
        }
        if (ds instanceof float[][]) {
            return Vectors.isNegative((float[][])ds);
        }
        if (ds instanceof int[][]) {
            return Vectors.isNegative((int[][])ds);
        }
        if (ds instanceof double[]) {
            return Vectors.isNegative((double[])ds);
        }
        if (ds instanceof float[]) {
            return Vectors.isNegative((float[])ds);
        }
        return Vectors.isNegative((int[])ds);
    }

    public static boolean isNegative(double[] ds) {
        int i = 0;
        while (i < ds.length) {
            if (ds[i] < 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNegative(double[][] pp) {
        int i = 0;
        while (i < pp.length) {
            if (Vectors.isNegative(pp[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPositive(int[] ds) {
        int i = 0;
        while (i < ds.length) {
            if (ds[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPositive(int[][] pp) {
        int i = 0;
        while (i < pp.length) {
            if (Vectors.isPositive(pp[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNegative(int[] ds) {
        int i = 0;
        while (i < ds.length) {
            if (ds[i] < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNegative(int[][] pp) {
        int i = 0;
        while (i < pp.length) {
            if (Vectors.isNegative(pp[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEqual(int[] a, int[] b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void removeFirst(int[] x, int val, int len, int gapval) {
        int k = 0;
        while (k < x.length) {
            if (x[k] == val) {
                System.arraycopy(x, k + 1, x, k, len - k - 1);
                x[len - 1] = -1;
            }
            ++k;
        }
    }

    public static void removeFirst(double[] x, double val, int len, double gapval) {
        int k = 0;
        while (k < x.length) {
            if (x[k] == val) {
                System.arraycopy(x, k + 1, x, k, len - k - 1);
                x[len - 1] = gapval;
            }
            ++k;
        }
    }

    public static <T> void removeFirst(T[] x, T val, int len, T gapval) {
        int k = 0;
        while (k < x.length) {
            if (x[k] == val) {
                System.arraycopy(x, k + 1, x, k, len - k - 1);
                x[len - 1] = gapval;
            }
            ++k;
        }
    }

    public static int[] resize(int[] x, int newlen, int fillval) {
        int[] u = new int[newlen];
        System.arraycopy(x, 0, u, 0, Math.min(newlen, x.length));
        int i = x.length;
        while (i < u.length) {
            u[i] = fillval;
            ++i;
        }
        x = null;
        return u;
    }

    public static double[] resize(double[] x, int newlen, double fillval) {
        double[] u = new double[newlen];
        System.arraycopy(x, 0, u, 0, Math.min(newlen, x.length));
        int i = x.length;
        while (i < u.length) {
            u[i] = fillval;
            ++i;
        }
        return u;
    }

    public static <T> T[] resize(T[] x, int newlen, T elementType) {
        Class<?> clazz = x.length > 0 ? x[0].getClass() : elementType.getClass();
        Object[] u = (Object[])Array.newInstance(clazz, newlen);
        System.arraycopy(x, 0, u, 0, Math.min(newlen, x.length));
        return u;
    }
}

