/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.Hashtable;
import java.util.Vector;

public class StopWatch {
    private static final String DEFAULT = "_default_";
    private static final int INVALID = -1;
    private long absStart = -1L;
    private long relPaused = 0L;
    private long absLap = -1L;
    private Vector<Long> laps = new Vector();
    private long absStop = -1L;
    private boolean running = false;
    private String name;
    protected static Hashtable<String, StopWatch> watches = new Hashtable();

    public static void main(String[] args) throws InterruptedException {
        StopWatch.start();
        Thread.sleep(1200L);
        System.out.println(StopWatch.format(StopWatch.read()));
        StopWatch.start("my");
        System.out.println(StopWatch.format(StopWatch.read("my")));
        int i = 0;
        while (i < 6) {
            Thread.sleep(140L);
            System.out.println(StopWatch.format(StopWatch.lap("my")));
            System.out.println(StopWatch.format(StopWatch.lap()));
            System.out.println(StopWatch.format(StopWatch.read()));
            System.out.println();
            ++i;
        }
        StopWatch.stop("my");
        System.out.println(StopWatch.get("my").debug());
        Thread.sleep(1000L);
        StopWatch.start("my");
        Thread.sleep(1000L);
        StopWatch.stop("my");
        System.out.println(StopWatch.get("my").debug());
    }

    protected StopWatch(String name) {
        this.name = name;
    }

    public static synchronized long start(String watch) {
        long now;
        StopWatch w = watches.get(watch);
        if (w == null) {
            w = new StopWatch(watch);
        }
        w.running = true;
        w.absLap = now = StopWatch.time();
        watches.put(watch, w);
        if (w.absStop == 0L) {
            w.absStart = now;
            return 0L;
        }
        w.relPaused += now - w.absStop;
        return now - w.absStart - w.relPaused;
    }

    public static long start() {
        return StopWatch.start(DEFAULT);
    }

    public static synchronized StopWatch clear(String watch) {
        return watches.remove(watch);
    }

    public static StopWatch clear() {
        return StopWatch.clear(DEFAULT);
    }

    public static StopWatch get(String watch) {
        return watches.get(watch);
    }

    public static StopWatch get() {
        return watches.get(DEFAULT);
    }

    public static synchronized long lap(String watch) {
        long now = StopWatch.time();
        StopWatch w = watches.get(watch);
        if (w == null || !w.running) {
            return -1L;
        }
        long relLap = now - w.absLap;
        w.absLap = now;
        w.laps.add(relLap);
        return relLap;
    }

    public static long lap() {
        return StopWatch.lap(DEFAULT);
    }

    public static synchronized long read(String watch) {
        long now = StopWatch.time();
        StopWatch w = watches.get(watch);
        if (w == null) {
            return -1L;
        }
        if (w.running) {
            return now - w.absStart - w.relPaused;
        }
        return w.absStop - w.absStart - w.relPaused;
    }

    public static long read() {
        return StopWatch.read(DEFAULT);
    }

    public static synchronized long stop(String watch) {
        long now = StopWatch.time();
        StopWatch w = watches.get(watch);
        if (w == null || !w.running) {
            return -1L;
        }
        w.absStop = now;
        w.running = false;
        return now - w.absStart - w.relPaused;
    }

    public static long stop() {
        return StopWatch.stop(DEFAULT);
    }

    public String debug() {
        String s = String.valueOf(this.name) + ": ";
        s = String.valueOf(s) + (this.running ? " running: " : " stopped: ");
        s = String.valueOf(s) + StopWatch.format(StopWatch.read(this.name));
        s = String.valueOf(s) + " lap times: ";
        for (long lap : this.laps) {
            s = String.valueOf(s) + StopWatch.format(lap) + " ";
        }
        return s;
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + StopWatch.format(StopWatch.read(this.name));
    }

    public static void print(String watch) {
        StopWatch w = watches.get(watch);
        if (w == null) {
            System.out.println(String.valueOf(watch) + " unknown");
        }
        System.out.println(w.toString());
    }

    public static void print() {
        StopWatch.print(DEFAULT);
    }

    public static synchronized String format(long reltime) {
        StringBuffer b = new StringBuffer();
        if (reltime == -1L) {
            return "[invalid]";
        }
        if (reltime < 0L) {
            b.append("-");
            reltime = -reltime;
        }
        long millis = reltime % 1000L;
        reltime -= millis;
        long secs = (reltime /= 1000L) % 60L;
        reltime -= secs;
        long mins = (reltime /= 60L) % 60L;
        reltime -= mins;
        if ((reltime /= 60L) > 0L) {
            b.append(reltime).append("h");
        }
        b.append(StopWatch.digits(mins, 2)).append("'");
        b.append(StopWatch.digits(secs, 2)).append("\"");
        b.append(StopWatch.digits(millis, 3));
        return b.toString();
    }

    public static synchronized String digits(long number, int digits) {
        String s = Long.toString(number);
        int len = s.length();
        if (len > digits) {
            return null;
        }
        if (len < digits) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < digits - len) {
                b.append('0');
                ++i;
            }
            b.append(s);
            s = b.toString();
        }
        return s;
    }

    protected static long time() {
        return System.currentTimeMillis();
    }

    public static final Hashtable<String, StopWatch> getWatches() {
        return watches;
    }

    public final String getName() {
        return this.name;
    }

    public final Vector<Long> getLaps() {
        return this.laps;
    }
}

