/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.Arrays;
import java.util.Random;
import org.knowceans.util.ArrayUtils;
import org.knowceans.util.CokusRandom;
import org.knowceans.util.Histogram;
import org.knowceans.util.Vectors;

public class RandomSamplers {
    private Random rand;
    protected boolean haveNextNextGaussian = false;
    protected double nextNextGaussian;
    public double lastRand;
    protected int MAXSTIRLING = 20000;
    protected int maxnn = 1;
    protected double[][] allss = new double[this.MAXSTIRLING][];
    protected double[] logmaxss = new double[this.MAXSTIRLING];
    protected double lmss = 0.0;

    public static void main(String[] args) {
        double x = 0.4;
        double y = 0.8;
        double[] probs = new double[]{0.5, 0.5};
        double[][] means = new double[][]{{x, 1.0 - x}, {y, 1.0 - y}};
        double[] precisions = new double[]{15.0, 15.0};
        Object xx = new double[200000][];
        int[] comps = new int[((double[][])xx).length];
        RandomSamplers rs = new RandomSamplers();
        xx = rs.randDmm(((double[][])xx).length, probs, means, precisions, comps);
        double[] result = Vectors.chooseColumn(xx, 0);
        Histogram.hist(System.out, result, 100);
        Histogram.hist(System.out, comps, 10);
    }

    public RandomSamplers() {
        this.rand = new CokusRandom();
    }

    public RandomSamplers(Random rand) {
        this.rand = rand;
    }

    protected double drand() {
        return this.rand.nextDouble();
    }

    public double randNorm(double mu, double sigma) {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian * sigma + mu;
        }
        while ((s = (v1 = 2.0 * this.drand() - 1.0) * v1 + (v2 = 2.0 * this.drand() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier * sigma + mu;
    }

    public double randGmm(double[] probs, double[] mean, double[] sigma) {
        return this.randGmm(1, probs, mean, sigma, null)[0];
    }

    public double randGmm(double[] probs, double[] mean, double[] sigma, int[] component) {
        return this.randGmm(1, probs, mean, sigma, component)[0];
    }

    public double[] randGmm(int n, double[] probs, double[] mean, double[] sigma) {
        return this.randGmm(n, probs, mean, sigma, null);
    }

    public double[] randGmm(int n, double[] probs, double[] mean, double[] sigma, int[] components) {
        double[] x = new double[n];
        int k = probs.length;
        double[] cumprobs = new double[k];
        cumprobs[0] = probs[0];
        int i = 1;
        while (i < k) {
            cumprobs[i] = cumprobs[i - 1] + probs[i];
            ++i;
        }
        i = 0;
        while (i < n) {
            double s = this.drand();
            int c = 0;
            c = 0;
            while (c < k) {
                if (s < cumprobs[c]) break;
                ++c;
            }
            if (components != null) {
                components[i] = c;
            }
            x[i] = this.randNorm(mean[c], sigma[c]);
            ++i;
        }
        return x;
    }

    public double[] randDmm(double[] probs, double[][] mean, double[] precision) {
        return this.randDmm(1, probs, mean, precision, null)[0];
    }

    public double[] randDmm(double[] probs, double[][] mean, double[] precision, int[] component) {
        return this.randDmm(1, probs, mean, precision, component)[0];
    }

    public double[][] randDmm(int n, double[] probs, double[][] means, double[] precisions) {
        return this.randDmm(n, probs, means, precisions, null);
    }

    public double[][] randDmm(int n, double[] probs, double[][] means, double[] precisions, int[] components) {
        double[][] x = new double[n][];
        double[] cumprobs = (double[])ArrayUtils.copy(probs);
        int i = 1;
        while (i < probs.length) {
            int n2 = i;
            cumprobs[n2] = cumprobs[n2] + cumprobs[i - 1];
            ++i;
        }
        int len = i;
        i = 0;
        while (i < n) {
            double randNum = this.drand() * cumprobs[len - 1];
            int c = this.binarySearch(cumprobs, randNum);
            if (components != null) {
                components[i] = c;
            }
            x[i] = this.randDir(means[c], precisions[c]);
            ++i;
        }
        return x;
    }

    public double randBeta(double aa, double bb) {
        double[] p = this.randDir(new double[]{aa, bb});
        return p[0];
    }

    public double[] randBeta(double[] aa, double[] bb) {
        double[] beta = new double[aa.length];
        int i = 0;
        while (i < beta.length) {
            beta[i] = this.randBeta(aa[i], bb[i]);
            ++i;
        }
        return beta;
    }

    public double randGamma(double rr) {
        double xx;
        if (rr <= 0.0) {
            return 0.0;
        }
        if (rr == 1.0) {
            return -Math.log(this.drand());
        }
        if (rr < 1.0) {
            double xx2;
            double yy;
            double cc = 1.0 / rr;
            double dd = 1.0 / (1.0 - rr);
            while (!((yy = (xx2 = Math.pow(this.drand(), cc)) + Math.pow(this.drand(), dd)) <= 1.0)) {
            }
            assert (yy != 0.0 && xx2 / yy > 0.0);
            return -Math.log(this.drand()) * xx2 / yy;
        }
        double bb = rr - 1.0;
        double cc = 3.0 * rr - 0.75;
        while (true) {
            double uu = this.drand();
            double vv = this.drand();
            double ww = uu * (1.0 - uu);
            double yy = Math.sqrt(cc / ww) * (uu - 0.5);
            xx = bb + yy;
            if (!(xx >= 0.0)) continue;
            double zz = 64.0 * ww * ww * ww * vv * vv;
            assert (zz > 0.0 && bb != 0.0 && xx / bb > 0.0);
            if (zz <= 1.0 - 2.0 * yy * yy / xx || Math.log(zz) <= 2.0 * (bb * Math.log(xx / bb) - yy)) break;
        }
        return xx;
    }

    public double[] randGamma(double[] aa) {
        double[] gamma = new double[aa.length];
        int i = 0;
        while (i < gamma.length) {
            gamma[i] = this.randGamma(aa[i]);
            ++i;
        }
        return gamma;
    }

    public double randGamma(double shape, double scale) {
        return this.randGamma(shape) * scale;
    }

    public int[] randPerm(int size) {
        int[] perm = Vectors.range(0, size - 1);
        return this.randPerm(perm);
    }

    public int[] randPerm(int[] set) {
        int i = set.length - 1;
        while (i > 0) {
            int k = (int)(this.drand() * (double)(i + 1));
            if (k != i) {
                int buf = set[i];
                set[i] = set[k];
                set[k] = buf;
            }
            --i;
        }
        return set;
    }

    public int[][] randPerm(int size, int parts) {
        int[] items = this.randPerm(size);
        return this.randParts(items, parts);
    }

    private int[][] randParts(int[] items, int parts) {
        int partSize = items.length / parts;
        int nModItems = items.length % parts;
        int[][] partitions = new int[parts][];
        int index = 0;
        int[] modItems = this.randPerm(parts);
        System.arraycopy(modItems, 0, nModItems, 0, nModItems);
        Arrays.sort(modItems);
        int i = 0;
        while (i < parts) {
            if (Arrays.binarySearch(modItems, i) >= 0) {
                System.arraycopy(items, index, partitions[i], 0, partSize + 1);
                ++index;
            } else {
                System.arraycopy(items, index, partitions[i], 0, partSize);
            }
            index += partSize;
            ++i;
        }
        return partitions;
    }

    public double[] randDir(double a, int dimension) {
        double[] aa = new double[dimension];
        Arrays.fill(aa, a);
        return this.randDir(aa);
    }

    public double[] randDir(double[] aa) {
        double[] ww = this.randGamma(aa);
        double sum = 0.0;
        int i = 0;
        while (i < ww.length) {
            sum += ww[i];
            ++i;
        }
        i = 0;
        while (i < ww.length) {
            int n = i++;
            ww[n] = ww[n] / sum;
        }
        return ww;
    }

    public double[] randDir(double[] mean, double precision) {
        double[] aa = new double[mean.length];
        int i = 0;
        while (i < mean.length) {
            aa[i] = mean[i] * precision;
            ++i;
        }
        return this.randDir(aa);
    }

    public double[][] randDir(double[][] aa, int direction) {
        double[][] ww = null;
        if (direction == 1) {
            ww = new double[aa.length][aa[0].length];
            double[] dirsmp = new double[aa.length];
            int i = 0;
            while (i < ww.length) {
                int j = 0;
                while (j < dirsmp.length) {
                    dirsmp[i] = aa[j][i];
                    ++j;
                }
                dirsmp = this.randDir(aa[i]);
                j = 0;
                while (j < dirsmp.length) {
                    ww[j][i] = dirsmp[j];
                    ++j;
                }
                ++i;
            }
        } else {
            ww = new double[aa.length][aa[0].length];
            int i = 0;
            while (i < ww.length) {
                ww[i] = this.randDir(aa[i]);
                ++i;
            }
        }
        return ww;
    }

    public double[][] randDir(double[] aa, int repetitions) {
        double[][] ww = new double[repetitions][aa.length];
        int i = 0;
        while (i < repetitions) {
            ww[i] = this.randDir(aa);
            ++i;
        }
        return ww;
    }

    public int[] randMultFreqs(double[] pp, int repetitions) {
        int[] freqs = new int[pp.length];
        int i = 0;
        while (i < freqs.length) {
            freqs[i] = 0;
            ++i;
        }
        i = 0;
        while (i < repetitions) {
            int n = this.randMult(pp);
            freqs[n] = freqs[n] + 1;
            ++i;
        }
        return freqs;
    }

    public int[] randMult(double[] pp, int repetitions) {
        int[] samples = new int[repetitions];
        int i = 0;
        while (i < repetitions) {
            samples[i] = this.randMult(pp);
            ++i;
        }
        return samples;
    }

    public int randMultSimple(double[] pp) {
        double[] cumPp = new double[pp.length];
        System.arraycopy(pp, 0, cumPp, 0, pp.length);
        int i = 1;
        while (i < pp.length) {
            int n = i;
            cumPp[n] = cumPp[n] + cumPp[i - 1];
            ++i;
        }
        double randNum = this.drand() * cumPp[i - 1];
        i = 0;
        while (i < cumPp.length) {
            if (cumPp[i] > randNum) break;
            ++i;
        }
        return i;
    }

    public void testMult() {
        int N = 100000;
        int[][] a = new int[2][N];
        RandomSamplers s = new RandomSamplers(new CokusRandom());
        double[] p = s.randDir(0.1, 10000);
        System.out.println(Vectors.print(p));
        s.getRand().setSeed(4357L);
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < N) {
            a[0][i] = s.randMult(p);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.println();
        s.getRand().setSeed(4357L);
        long t2 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < N) {
            a[1][i2] = s.randMult(p);
            ++i2;
        }
        long t3 = System.currentTimeMillis();
        System.out.println("linear search: " + (t1 - t0) + " binary search: " + (t3 - t2));
    }

    public int randMult(double[] pp) {
        double[] cumPp = new double[pp.length];
        System.arraycopy(pp, 0, cumPp, 0, pp.length);
        int i = 1;
        while (i < pp.length) {
            int n = i;
            cumPp[n] = cumPp[n] + cumPp[i - 1];
            ++i;
        }
        double randNum = this.drand() * cumPp[i - 1];
        i = this.binarySearch(cumPp, randNum);
        return i;
    }

    public int randMultDirect(double[] pp) {
        double randNum;
        int i = 1;
        while (i < pp.length) {
            int n = i;
            pp[n] = pp[n] + pp[i - 1];
            ++i;
        }
        this.lastRand = randNum = this.drand() * pp[i - 1];
        i = this.binarySearch(pp, randNum);
        return i;
    }

    public int randMultDirect(double[] pp, double randnum) {
        int i = 1;
        while (i < pp.length) {
            int n = i;
            pp[n] = pp[n] + pp[i - 1];
            ++i;
        }
        i = this.binarySearch(pp, randnum);
        return i;
    }

    public int binarySearch(double[] a, double p) {
        if (p < a[0]) {
            return 0;
        }
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = a[mid];
            if (midVal < p) {
                low = mid + 1;
                continue;
            }
            if (midVal > p) {
                if (a[mid - 1] < p) {
                    return mid;
                }
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return a.length;
    }

    public int randBinom(double N, double p) {
        int n = 0;
        int i = 0;
        while ((double)i < N) {
            if (this.randBernoulli(p) == 1) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public int randBernoulli(double p) {
        double a = this.drand();
        if (a < p) {
            return 1;
        }
        return 0;
    }

    public double randConParam(double alpha, int numgroup, int[] numdata, int[] numtable, double alphaa, double alphab, int numiter) {
        int iter = 0;
        while (iter < numiter) {
            double aa = alphaa;
            double bb = alphab;
            int jj = 0;
            while (jj < numgroup) {
                int nd = numdata[jj];
                double eta = this.randBeta(alpha + 1.0, nd);
                int zz = this.drand() * (alpha + (double)nd) < (double)nd ? 1 : 0;
                aa += (double)(numtable[jj] - zz);
                bb -= Math.log(eta);
                ++jj;
            }
            alpha = this.randGamma(aa) / bb;
            ++iter;
        }
        return alpha;
    }

    public double randConParam(double alpha, int numdata, int numtopic, double alphaa, double alphab, int numiter) {
        double alphaAvg = 0.0;
        int iter = 0;
        while (iter < numiter) {
            double aa = alphaa;
            double bb = alphab;
            double eta = this.randBeta(alpha + 1.0, numdata);
            double pi = 1.0 / ((double)numdata * (alphab - Math.log(eta)) / (alphaa + (double)numtopic - 1.0) + 1.0);
            int zz = this.drand() > pi ? 1 : 0;
            alpha = this.randGamma(aa += (double)(numtopic - zz)) / (bb -= Math.log(eta));
            alphaAvg += alpha;
            ++iter;
        }
        return alphaAvg / (double)numiter;
    }

    public CrpData randCrp(double alpha, int numdata) {
        return this.randCrp(new double[]{alpha}, numdata);
    }

    public CrpData randCrp(double[] alpha, int numdata) {
        double[] weights = Vectors.copy(alpha);
        CrpData crp = new CrpData(numdata);
        int ii = 0;
        while (ii < numdata) {
            crp.cc[ii] = this.randMult(weights);
            if (crp.cc[ii] > crp.numclass) {
                weights = Vectors.concat(Vectors.subVector(weights, 0, crp.numclass - 1), new double[]{1.0}, alpha);
                crp.numclass = crp.cc[ii];
            } else {
                int n = crp.cc[ii];
                weights[n] = weights[n] + 1.0;
            }
            ++ii;
        }
        return crp;
    }

    public int randNumTable(double alpha, int numdata) {
        if (numdata == 0) {
            return 0;
        }
        int numtable = 1;
        int ii = 1;
        while (ii < numdata) {
            if (this.drand() < alpha / ((double)ii + alpha)) {
                ++numtable;
            }
            ++ii;
        }
        return numtable;
    }

    public double[] randStick(double[] alpha, int numclass) {
        double[] beta = new double[numclass];
        double[] zz = new double[numclass];
        int i = 0;
        while (i < zz.length) {
            zz[i] = this.randBeta(1.0, alpha[i]);
            ++i;
        }
        beta[0] = 1.0;
        i = 1;
        while (i < numclass) {
            beta[i] = (1.0 - zz[i - 1]) * beta[i - 1];
            ++i;
        }
        i = 0;
        while (i < numclass) {
            int n = i;
            beta[n] = beta[n] * zz[i];
            ++i;
        }
        return beta;
    }

    public double enumClass(double alpha, int numdata) {
        double numclass = 0.0;
        int ii = 1;
        while (ii <= numdata) {
            numclass += 1.0 / (alpha - 1.0 + (double)ii);
            ++ii;
        }
        return numclass * alpha;
    }

    public String randString(int length, byte[] alphabet) {
        if (alphabet == null) {
            alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".getBytes();
        }
        byte[] pass = new byte[length];
        int k = 0;
        while (k < length) {
            int i = (int)Math.floor(this.drand() * (double)alphabet.length);
            pass[k] = alphabet[i];
            ++k;
        }
        return new String(pass);
    }

    public double[] stirling(int nn) {
        if (this.allss[0] == null) {
            this.allss[0] = new double[1];
            this.allss[0][0] = 1.0;
            this.logmaxss[0] = 0.0;
        }
        if (nn > this.maxnn) {
            int mm = this.maxnn;
            while (mm < nn) {
                int len = this.allss[mm - 1].length + 1;
                this.allss[mm] = new double[len];
                int xx = 0;
                while (xx < len) {
                    double[] dArray = this.allss[mm];
                    int n = xx;
                    dArray[n] = dArray[n] + (xx < len - 1 ? this.allss[mm - 1][xx] * (double)mm : 0.0);
                    double[] dArray2 = this.allss[mm];
                    int n2 = xx;
                    dArray2[n2] = dArray2[n2] + (xx == 0 ? 0.0 : this.allss[mm - 1][xx - 1]);
                    ++xx;
                }
                double mss = Vectors.max(this.allss[mm]);
                Vectors.mult(this.allss[mm], 1.0 / mss);
                this.logmaxss[mm] = this.logmaxss[mm - 1] + Math.log(mss);
                ++mm;
            }
            this.maxnn = nn;
        }
        this.lmss = this.logmaxss[nn - 1];
        return this.allss[nn - 1];
    }

    public int randAntoniak(double alpha, int n) {
        double[] p = this.stirling(n);
        double aa = 1.0;
        int m = 0;
        while (m < p.length) {
            int n2 = m++;
            p[n2] = p[n2] * aa;
            aa *= alpha;
        }
        return this.randMultDirect(p) + 1;
    }

    public int randUniform(int numvalue) {
        return (int)Math.floor(this.drand() * (double)numvalue);
    }

    public final Random getRand() {
        return this.rand;
    }

    public final void setRand(Random rand) {
        this.rand = rand;
    }

    public class CrpData {
        public int[] cc;
        public int numclass;

        public CrpData(int numdata) {
            this.cc = Vectors.ones(numdata, 0);
            this.numclass = 0;
        }
    }
}

