/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class ParallelFor {
    protected int nthreads;
    protected ExecutorService threadpool;
    protected int iter = 0;
    protected final Worker[] workers;
    protected boolean isStopping;
    protected int niter = 0;
    protected int activeWorkers = 0;

    public ParallelFor() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ParallelFor(int nthreads) {
        this.nthreads = nthreads;
        if (this.threadpool == null) {
            this.threadpool = Executors.newFixedThreadPool(nthreads);
        }
        this.workers = new Worker[nthreads];
        int i = 0;
        while (i < nthreads) {
            this.workers[i] = new Worker(i);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(int N) {
        this.isStopping = false;
        this.niter = N;
        this.iter = 0;
        int i = 0;
        while (i < this.nthreads) {
            this.threadpool.execute(this.workers[i]);
            ParallelFor parallelFor = this;
            synchronized (parallelFor) {
                ++this.activeWorkers;
            }
            ++i;
        }
        while (this.activeWorkers > 0) {
            ParallelFor parallelFor = this;
            synchronized (parallelFor) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void loopOnce(int N) {
        this.loop(N);
        this.shutdown();
    }

    public abstract void process(int var1, int var2);

    public void stop() {
        this.isStopping = true;
    }

    public void shutdown() {
        try {
            this.threadpool.shutdown();
            this.threadpool.awaitTermination(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int niter = 10;
        ParallelFor x = new ParallelFor(){

            @Override
            public void process(int y, int id) {
                int i = 0;
                while (i < 5) {
                    try {
                        Thread.sleep((int)(Math.random() * 1000.0));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("iteration " + y + " on processor " + id);
                    ++i;
                }
            }
        };
        x.loop(niter);
        System.out.println("first join");
        x.loopOnce(niter);
        System.out.println("second join and finish");
    }

    private class Worker
    implements Runnable {
        int id;

        public Worker(int threadid) {
            this.id = threadid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ParallelFor.this.isStopping) {
                int i = 0;
                ParallelFor parallelFor = ParallelFor.this;
                synchronized (parallelFor) {
                    i = ParallelFor.this.iter++;
                }
                if (i >= ParallelFor.this.niter) break;
                ParallelFor.this.process(i, this.id);
            }
            ParallelFor parallelFor = ParallelFor.this;
            synchronized (parallelFor) {
                --ParallelFor.this.activeWorkers;
                ParallelFor.this.notifyAll();
            }
        }
    }
}

