/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.Comparator;
import java.util.List;
import org.knowceans.util.Vectors;

public class IndexQuickSort {
    public static void main(String[] args) {
        double[] weights = new double[]{0.1, 0.1, 0.001, 0.05, 0.2, 0.3, 0.5, 0.03, 0.02, 0.1};
        Double[] weights2 = new Double[]{0.1, 0.1, 0.001, 0.05, 0.2, 0.3, 0.5, 0.03, 0.02, 0.1};
        Comparator<Double> cmp = new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o1, o2);
            }
        };
        int i = 0;
        while (i < weights.length) {
            System.out.println(String.valueOf(i) + "\t" + weights[i]);
            ++i;
        }
        System.out.println("sorted");
        int[] index = IndexQuickSort.sort(weights);
        int i2 = 0;
        while (i2 < index.length) {
            System.out.println(String.valueOf(i2) + "\t" + weights[index[i2]] + "\t" + index[i2]);
            ++i2;
        }
        System.out.println("reversed");
        IndexQuickSort.reverse(index);
        i2 = 0;
        while (i2 < index.length) {
            System.out.println(String.valueOf(i2) + "\t" + weights[index[i2]] + "\t" + index[i2]);
            ++i2;
        }
        System.out.println("inverse");
        int[] index2 = IndexQuickSort.inverse(index);
        int i3 = 0;
        while (i3 < index2.length) {
            System.out.println(String.valueOf(i3) + "\t" + weights[index2[index[i3]]] + "\t" + index2[i3]);
            ++i3;
        }
        System.out.println("now with objects");
        i3 = 0;
        while (i3 < weights.length) {
            System.out.println(String.valueOf(i3) + "\t" + weights[i3]);
            ++i3;
        }
        System.out.println("sorted");
        index = IndexQuickSort.sort(weights2, cmp);
        i3 = 0;
        while (i3 < index.length) {
            System.out.println(String.valueOf(i3) + "\t" + weights2[index[i3]] + "\t" + index[i3]);
            ++i3;
        }
        System.out.println("reversed");
        IndexQuickSort.reverse(index);
        i3 = 0;
        while (i3 < index.length) {
            System.out.println(String.valueOf(i3) + "\t" + weights2[index[i3]] + "\t" + index[i3]);
            ++i3;
        }
        int[] xx = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112};
        int[] nArray = new int[13];
        nArray[1] = 11;
        nArray[2] = 10;
        nArray[3] = 9;
        nArray[4] = 5;
        nArray[5] = 7;
        nArray[6] = 6;
        nArray[7] = 3;
        nArray[8] = 4;
        nArray[9] = 8;
        nArray[10] = 2;
        nArray[11] = 1;
        nArray[12] = 12;
        int[] order = nArray;
        IndexQuickSort.reorder(xx, order);
        System.out.println(Vectors.print(xx));
    }

    public static void sort(double[] fixedArray, int[] index) {
        IndexQuickSort.sort(fixedArray, index, 0, index.length - 1);
    }

    public static int[] sort(double[] fixedArray) {
        int[] index = Vectors.range(0, fixedArray.length - 1);
        IndexQuickSort.sort(fixedArray, index, 0, index.length - 1);
        return index;
    }

    public static int[] inverse(int[] index) {
        return IndexQuickSort.sort(index);
    }

    public static void inverse(int[] index, int[] invindex) {
        IndexQuickSort.sort(index, invindex);
    }

    public static void reverse(int[] index) {
        int N = index.length;
        int i = 0;
        while (i < N / 2) {
            IndexQuickSort.swap(index, i, N - 1 - i);
            ++i;
        }
    }

    public static void sort(double[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = IndexQuickSort.part(a, index, left, right);
        IndexQuickSort.sort(a, index, left, i - 1);
        IndexQuickSort.sort(a, index, i + 1, right);
    }

    private static int part(double[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]]) {
                if (j == left) break;
            }
            if (i >= j) break;
            IndexQuickSort.swap(index, i, j);
        }
        IndexQuickSort.swap(index, i, right);
        return i;
    }

    public static void swap(int[] index, int i, int j) {
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static void swap(double[] index, int i, int j) {
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static <T> void swap(T[] index, int i, int j) {
        T b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static void sort(int[] fixedArray, int[] index) {
        IndexQuickSort.sort(fixedArray, index, 0, index.length - 1);
    }

    public static int[] sort(int[] fixedArray) {
        int[] index = Vectors.range(0, fixedArray.length - 1);
        IndexQuickSort.sort(fixedArray, index, 0, index.length - 1);
        return index;
    }

    public static <T> int[] sort(List<T> fixedList) {
        Object[] array = fixedList.toArray();
        return IndexQuickSort.sort(array, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        });
    }

    public static void sort(int[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = IndexQuickSort.part(a, index, left, right);
        IndexQuickSort.sort(a, index, left, i - 1);
        IndexQuickSort.sort(a, index, i + 1, right);
    }

    private static int part(int[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]]) {
                if (j == left) break;
            }
            if (i >= j) break;
            IndexQuickSort.swap(index, i, j);
        }
        IndexQuickSort.swap(index, i, right);
        return i;
    }

    public static <T> void sort(T[] fixedArray, Comparator<T> cmp, int[] index) {
        IndexQuickSort.sort(fixedArray, cmp, index, 0, index.length - 1);
    }

    public static <T> int[] sort(T[] fixedArray, Comparator<T> cmp) {
        int[] index = Vectors.range(0, fixedArray.length - 1);
        IndexQuickSort.sort(fixedArray, cmp, index, 0, index.length - 1);
        return index;
    }

    public static <T> void sort(T[] a, Comparator<T> cmp, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = IndexQuickSort.part(a, cmp, index, left, right);
        IndexQuickSort.sort(a, cmp, index, left, i - 1);
        IndexQuickSort.sort(a, cmp, index, i + 1, right);
    }

    private static <T> int part(T[] a, Comparator<T> cmp, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (cmp.compare(a[index[++i]], a[index[right]]) == -1) {
                continue;
            }
            while (cmp.compare(a[index[right]], a[index[--j]]) == -1) {
                if (j == left) break;
            }
            if (i >= j) break;
            IndexQuickSort.swap(index, i, j);
        }
        IndexQuickSort.swap(index, i, right);
        return i;
    }

    public static void resortinc(int[] x, int[] idx, int[] invidx, int inc) {
        inc = invidx[inc];
        while (inc > 0 && x[idx[inc]] > x[idx[inc - 1]]) {
            int tmp = idx[inc];
            idx[inc] = idx[inc - 1];
            idx[inc - 1] = tmp;
            tmp = invidx[idx[inc]];
            invidx[idx[inc]] = invidx[idx[inc - 1]];
            invidx[idx[inc - 1]] = tmp;
            --inc;
        }
    }

    public static void resortdec(int[] x, int[] idx, int[] invidx, int dec) {
        dec = invidx[dec];
        while (dec < x.length - 1 && x[idx[dec]] < x[idx[dec + 1]]) {
            int tmp = idx[dec];
            idx[dec] = idx[dec + 1];
            idx[dec + 1] = tmp;
            tmp = invidx[idx[dec]];
            invidx[idx[dec]] = invidx[idx[dec + 1]];
            invidx[idx[dec + 1]] = tmp;
            ++dec;
        }
    }

    public static void reorder(double[] x, int[] order) {
        int[] inv = IndexQuickSort.inverse(order);
        int j = x.length - 1;
        while (j >= 0) {
            int i = 0;
            while (i < j) {
                if (inv[i] > inv[i + 1]) {
                    IndexQuickSort.swap(inv, i, i + 1);
                    IndexQuickSort.swap(x, i, i + 1);
                }
                ++i;
            }
            --j;
        }
    }

    public static void reorder(int[] x, int[] order) {
        int[] inv = IndexQuickSort.inverse(order);
        int j = x.length - 1;
        while (j >= 0) {
            int i = 0;
            while (i < j) {
                if (inv[i] > inv[i + 1]) {
                    IndexQuickSort.swap(inv, i, i + 1);
                    IndexQuickSort.swap(x, i, i + 1);
                }
                ++i;
            }
            --j;
        }
    }

    public static <T> void reorder(T[] x, int[] order) {
        int[] inv = IndexQuickSort.inverse(order);
        int j = x.length - 1;
        while (j >= 0) {
            int i = 0;
            while (i < j) {
                if (inv[i] > inv[i + 1]) {
                    IndexQuickSort.swap(inv, i, i + 1);
                    IndexQuickSort.swap(x, i, i + 1);
                }
                ++i;
            }
            --j;
        }
    }

    public static <T> void reorder(List<T> x, int[] order) {
        int[] inv = IndexQuickSort.inverse(order);
        int j = x.size() - 1;
        while (j >= 0) {
            int i = 0;
            while (i < j) {
                if (inv[i] > inv[i + 1]) {
                    IndexQuickSort.swap(inv, i, i + 1);
                    T temp = x.get(i);
                    x.set(i, x.get(i + 1));
                    x.set(i + 1, temp);
                }
                ++i;
            }
            --j;
        }
    }
}

