/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.knowceans.util.ArrayUtils;

public class Histogram {
    public static double[] hist(PrintStream out, double[] data, double low, double high, int bins, int fmax) {
        double binwidth = (high - low) / (double)bins;
        double[] binhigh = new double[bins];
        double[] hist = new double[bins];
        binhigh[0] = low + binwidth;
        int i = 1;
        while (i < bins) {
            binhigh[i] = binhigh[i - 1] + binwidth;
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int c = 0;
            if (data[i] >= high) {
                int n = bins - 1;
                hist[n] = hist[n] + 1.0;
            } else {
                c = 0;
                while (c < bins) {
                    if (data[i] < binhigh[c]) break;
                    ++c;
                }
                int n = c;
                hist[n] = hist[n] + 1.0;
            }
            ++i;
        }
        double hmax = 0.0;
        int i2 = 0;
        while (i2 < hist.length) {
            hmax = Math.max(hist[i2], hmax);
            ++i2;
        }
        double shrink = (double)fmax / hmax;
        int i3 = 0;
        while (i3 < hist.length) {
            hist[i3] = shrink * hist[i3];
            ++i3;
        }
        if (out != null) {
            DecimalFormat nf = new DecimalFormat("0.00");
            String scale = "0";
            int i4 = 1;
            while (i4 < fmax / 10 + 1) {
                scale = String.valueOf(scale) + "    .    " + i4 % 10;
                ++i4;
            }
            String legend = "x" + nf.format(hmax / (double)fmax * 10.0) + " ";
            if (legend.length() < 9) {
                char[] fill = new char[8 - legend.length()];
                Arrays.fill(fill, ' ');
                legend = String.valueOf(legend) + new String(fill);
            } else {
                scale = scale.substring(legend.length() - 8);
            }
            out.println(String.valueOf(legend) + scale);
            out.println(String.valueOf(low) + "\t.");
            int i5 = 0;
            while (i5 < hist.length) {
                String x = nf.format(binhigh[i5] - binwidth / 2.0);
                out.print(String.valueOf(x) + "\t|");
                int j = 0;
                while ((long)j < Math.round(hist[i5])) {
                    if ((j + 1) % 10 == 0) {
                        out.print("]");
                    } else {
                        out.print("|");
                    }
                    ++j;
                }
                out.println();
                ++i5;
            }
            out.println(String.valueOf(high) + "\t.");
        }
        return hist;
    }

    public static int[] hist(double[] data, double low, double high, int bins) {
        double binwidth = (high - low) / (double)bins;
        double[] binhigh = new double[bins];
        int[] hist = new int[bins];
        binhigh[0] = low + binwidth;
        int i = 1;
        while (i < bins) {
            binhigh[i] = binhigh[i - 1] + binwidth;
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int c = 0;
            if (data[i] >= high) {
                int n = bins - 1;
                hist[n] = hist[n] + 1;
            } else {
                c = 0;
                while (c < bins) {
                    if (data[i] < binhigh[c]) break;
                    ++c;
                }
                int n = c;
                hist[n] = hist[n] + 1;
            }
            ++i;
        }
        return hist;
    }

    public static double[] hist(PrintStream out, Set<Double> data, int size) {
        return Histogram.hist(out, new ArrayList<Double>(data), size);
    }

    public static double[] hist(PrintStream out, List<Double> data, int size) {
        return Histogram.hist(out, (double[])ArrayUtils.asPrimitiveArray(data), size);
    }

    public static double[] hist(PrintStream out, double[] data, int size) {
        double low = Double.POSITIVE_INFINITY;
        double high = Double.NEGATIVE_INFINITY;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            low = Math.min(x, low);
            high = Math.max(x, high);
            ++n2;
        }
        int bins = (int)(0.7 * (double)size);
        low -= (high - low) * 2.0 / (double)bins;
        high += (high - low) * 2.0 / (double)bins;
        return Histogram.hist(out, data, low, high, bins, size);
    }

    public static TreeMap<Integer, Integer> hist(PrintStream out, int[] data, int size) {
        TreeMap<Integer, Integer> hist = new TreeMap<Integer, Integer>();
        int i = 0;
        while (i < data.length) {
            if (hist.containsKey(data[i])) {
                hist.put(data[i], (Integer)hist.get(data[i]) + 1);
            } else {
                hist.put(data[i], 1);
            }
            ++i;
        }
        ArrayList v = new ArrayList(hist.values());
        Collections.sort(v);
        int max = (Integer)v.get(v.size() - 1);
        double factor = (double)size / (double)max;
        for (Map.Entry e : hist.entrySet()) {
            out.print(e.getKey() + "\t");
            int j = 0;
            while ((long)j < Math.round((double)((Integer)e.getValue()).intValue() * factor)) {
                if ((j + 1) % 10 == 0) {
                    out.print("]");
                } else {
                    out.print("|");
                }
                ++j;
            }
            out.println();
        }
        return hist;
    }
}

