/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import org.knowceans.util.Vectors;

public class Gamma {
    public static final double GAMMA = 0.5772156649015329;
    private static final double[] lanczos = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);
    private static final double GAMMA_MINX = 1.0E-12;
    private static final double DIGAMMA_MINNEGX = -1250.0;
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;

    public static double lgamma(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (x >= 0.0 && x <= 1.0E-12) {
            x = 1.0E-12;
        }
        double g = 4.7421875;
        double sum = 0.0;
        int i = lanczos.length - 1;
        while (i > 0) {
            sum += lanczos[i] / (x + (double)i);
            --i;
        }
        double tmp = x + g + 0.5;
        double ret = (x + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log((sum += lanczos[0]) / x);
        return ret;
    }

    public static double lgamma0(double x) {
        assert (x > 0.0) : "lgamma(" + x + ")";
        double z = 1.0 / (x * x);
        z = (((-5.95238095238E-4 * z + 7.93650793651E-4) * z - 0.002777777777778) * z + 0.083333333333333) / (x += 6.0);
        z = (x - 0.5) * Math.log(x) - x + 0.918938533204673 + z - Math.log(x - 1.0) - Math.log(x - 2.0) - Math.log(x - 3.0) - Math.log(x - 4.0) - Math.log(x - 5.0) - Math.log(x - 6.0);
        return z;
    }

    public static double fgamma(double x) {
        return Math.exp(Gamma.lgamma(x));
    }

    public static int factorial(int n) {
        return (int)Math.exp(Gamma.lgamma(n + 1));
    }

    public static double ldelta(double[] x) {
        double lognum = 0.0;
        double den = 0.0;
        int i = 0;
        while (i < x.length) {
            lognum += Gamma.lgamma(x[i]);
            den += x[i];
            ++i;
        }
        return lognum - Gamma.lgamma(den);
    }

    public static double fdelta(double[] x) {
        return Math.exp(Gamma.ldelta(x));
    }

    public static double ldelta(int[] x) {
        double lognum = 0.0;
        double den = 0.0;
        int i = 0;
        while (i < x.length) {
            lognum += Gamma.lgamma(x[i]);
            den += (double)x[i];
            ++i;
        }
        return lognum - Gamma.lgamma(den);
    }

    public static double fdelta(int[] x) {
        return Math.exp(Gamma.ldelta(x));
    }

    public static double ldelta(int[] x, double alpha) {
        double lognum = 0.0;
        double den = 0.0;
        int i = 0;
        while (i < x.length) {
            lognum += Gamma.lgamma((double)x[i] + alpha);
            den += (double)x[i];
            ++i;
        }
        return lognum - Gamma.lgamma(den += alpha * (double)x.length);
    }

    public static double ldelta(int[] x, double[] alpha) {
        double lognum = 0.0;
        double den = 0.0;
        int i = 0;
        while (i < x.length) {
            lognum += Gamma.lgamma((double)x[i] + alpha[i]);
            den += (double)x[i];
            ++i;
        }
        return lognum - Gamma.lgamma(den += Vectors.sum(alpha) * (double)x.length);
    }

    public static double fdelta(int[] x, double alpha) {
        return Math.exp(Gamma.ldelta(x, alpha));
    }

    public static double ldelta(int K, double x) {
        double delta = (double)K * Gamma.lgamma(x) - Gamma.lgamma((double)K * x);
        return delta;
    }

    public static double fdelta(int K, double x) {
        return Math.exp(Gamma.ldelta(K, x));
    }

    public static double fdeltaRatio(int[] nk, double[] alphak, int[] nkless, double[] tempk) {
        double rat = 0.0;
        Vectors.copy(nk, tempk);
        Vectors.add(tempk, alphak);
        rat = Gamma.ldelta(tempk);
        Vectors.subtract(tempk, nkless);
        return Math.exp(rat -= Gamma.ldelta(tempk));
    }

    public static double digamma(double x) {
        if (x >= 0.0 && x < 1.0E-12) {
            x = 1.0E-12;
        }
        if (x < -1250.0) {
            return Gamma.digamma(-1249.999999999999);
        }
        if (x > 0.0 && x <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / x;
        }
        if (x >= 49.0) {
            double inv = 1.0 / (x * x);
            return Math.log(x) - 0.5 / x - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / 252.0));
        }
        return Gamma.digamma(x + 1.0) - 1.0 / x;
    }

    public static double digamma0(double x) {
        assert (x > 0.0) : "digamma(" + x + ")";
        double p = 1.0 / ((x += 6.0) * x);
        p = (((0.004166666666667 * p - 0.003968253986254) * p + 0.008333333333333) * p - 0.083333333333333) * p;
        p = p + Math.log(x) - 0.5 / x - 1.0 / (x - 1.0) - 1.0 / (x - 2.0) - 1.0 / (x - 3.0) - 1.0 / (x - 4.0) - 1.0 / (x - 5.0) - 1.0 / (x - 6.0);
        return p;
    }

    public static double invdigamma(double y) {
        double x = 0.0;
        x = y >= -2.22 ? Math.exp(y) + 0.5 : -1.0 / (y + 0.5772156649015329);
        int i = 0;
        while (i < 5) {
            x -= (Gamma.digamma(x) - y) / Gamma.trigamma(x);
            ++i;
        }
        return x;
    }

    public static double trigamma(double x) {
        if (x > 0.0 && x <= 1.0E-5) {
            return 1.0 / (x * x);
        }
        if (x >= 49.0) {
            double inv = 1.0 / (x * x);
            return 1.0 / x + inv / 2.0 + inv / x * (0.16666666666666666 - inv * (0.03333333333333333 + inv / 42.0));
        }
        return Gamma.trigamma(x + 1.0) + 1.0 / (x * x);
    }

    public static double trigamma0(double x) {
        assert (x > 0.0) : "trigamma(" + x + ")";
        double p = 1.0 / ((x += 6.0) * x);
        p = (((((0.075757575757576 * p - 0.033333333333333) * p + 0.0238095238095238) * p - 0.033333333333333) * p + 0.166666666666667) * p + 1.0) / x + 0.5 * p;
        int i = 0;
        while (i < 6) {
            p = 1.0 / ((x -= 1.0) * x) + p;
            ++i;
        }
        return p;
    }

    public static long fak(int i) {
        if (i > 1) {
            return (long)i * Gamma.fak(i - 1);
        }
        return 1L;
    }

    double pochhammer(double x, int n) {
        double result;
        if (n == 0) {
            return 0.0;
        }
        if (n <= 20) {
            double xi;
            result = xi = x;
            int i = n - 1;
            while (i > 0) {
                result *= (xi += 1.0);
                --i;
            }
            result = Math.log(result);
        } else {
            result = x >= 10000.0 * (double)n ? Math.log(x) + (double)(n - 1) * Math.log(x + (double)(n / 2)) : Gamma.lgamma(x + (double)n) - Gamma.lgamma(x);
        }
        return result;
    }

    public static double diPochhammer(double x, int n) {
        double result;
        if (n == 0) {
            return 0.0;
        }
        if (n <= 20) {
            double xi = x;
            result = 1.0 / xi;
            int i = n - 1;
            while (i > 0) {
                result += 1.0 / (xi += 1.0);
                --i;
            }
        } else {
            result = Gamma.digamma(x + (double)n) - Gamma.digamma(x);
        }
        return result;
    }

    public static double triPochhammer(double x, int n) {
        if (n == 0) {
            return 0.0;
        }
        if (n <= 20) {
            double result = -1.0 / (x * x);
            --n;
            while (n > 0) {
                result -= 1.0 / ((x += 1.0) * x);
                --n;
            }
            return result;
        }
        return Gamma.trigamma(x + (double)n) - Gamma.trigamma(x);
    }
}

