/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.Arrays;

public class ExpDouble {
    private static double log10 = Math.log(10.0);
    long mantissa;
    int exponent;
    int digits;
    int magnitude;
    double value;
    boolean negative;

    public static void main(String[] args) {
        double[] x = new double[]{0.0, -1.0099638, 3.56, 30.0, -300.04, -4.5383487E7, 9.998, 3.4598E16};
        int i = 0;
        while (i < x.length) {
            ExpDouble a = new ExpDouble(x[i], 5);
            a.round(3);
            System.out.println(a.debug());
            a.round(1);
            System.out.println(a.toExpString());
            ++i;
        }
    }

    public ExpDouble(double x, int maxdigits) {
        if (x == 0.0) {
            x = Math.pow(10.0, -maxdigits - 1);
            this.magnitude = -1;
            maxdigits = 1;
        } else {
            this.magnitude = ExpDouble.orderOfMagnitude(x);
        }
        this.formatExponential(x, maxdigits);
        this.value = x;
    }

    public boolean round(int ndigits) {
        int diff = this.digits - ndigits;
        if (diff <= 0) {
            return false;
        }
        this.mantissa = Math.round((double)this.mantissa / Math.pow(10.0, diff));
        this.exponent += diff;
        this.digits -= diff;
        if (ExpDouble.orderOfMagnitude(this.mantissa) >= this.digits) {
            this.mantissa /= 10L;
            ++this.exponent;
            ++this.magnitude;
            return true;
        }
        return false;
    }

    int strlen() {
        if (Double.isInfinite(this.value)) {
            return this.negative ? 4 : 3;
        }
        if (Double.isNaN(this.value)) {
            return 3;
        }
        int len = this.digits;
        if (this.negative) {
            ++len;
        }
        if (this.exponent < 0) {
            ++len;
            int tz = -this.exponent - this.digits;
            if (tz >= 0) {
                len += tz;
                ++len;
            }
        } else {
            len += this.exponent;
        }
        return len;
    }

    int strlenexp() {
        if (Double.isInfinite(this.value)) {
            return this.negative ? 4 : 3;
        }
        if (Double.isNaN(this.value)) {
            return 3;
        }
        int len = this.minstrlenexp();
        if (this.digits == 1) {
            return len;
        }
        return this.minstrlenexp() + this.digits;
    }

    int minstrlenexp() {
        if (Double.isInfinite(this.value)) {
            return this.negative ? 4 : 3;
        }
        if (Double.isNaN(this.value)) {
            return 3;
        }
        int len = 3;
        if (this.negative) {
            ++len;
        }
        if (this.value < 1.0) {
            ++len;
        }
        if (this.value < 1.0E-10 || this.value > 1.0E10) {
            ++len;
        }
        return len;
    }

    public String toString() {
        if (Double.isInfinite(this.value)) {
            return this.negative ? "-inf" : "inf";
        }
        if (Double.isNaN(this.value)) {
            return "nan";
        }
        String[] pp = this.parts();
        if (pp[1] == null) {
            return pp[0];
        }
        return pp[0] + "." + pp[1];
    }

    public String toExpString() {
        double factor = Math.pow(10.0, this.digits - 1);
        double m = (double)this.mantissa / factor;
        String s = this.negative ? "-" : "";
        s = this.digits == 1 ? String.valueOf(s) + Long.toString((long)m) : String.valueOf(s) + Double.toString(m);
        s = String.valueOf(s) + "E" + (this.exponent + this.digits - 1);
        return s;
    }

    public String debug() {
        return String.valueOf(this.toString()) + " = " + this.mantissa + "E" + this.exponent + " (" + "neg=" + this.negative + ",digits=" + this.digits + ",magnitude=" + this.magnitude + ",strlen=" + this.strlen() + ")";
    }

    public double toDoubleUnsigned() {
        return (double)this.mantissa * Math.pow(10.0, this.exponent);
    }

    public double toDouble() {
        double x = this.toDouble();
        return this.negative ? -x : x;
    }

    protected String[] parts() {
        String[] parts = new String[2];
        parts[0] = Long.toString((long)this.toDoubleUnsigned());
        StringBuffer frac = new StringBuffer();
        if (this.exponent < 0) {
            char[] zz;
            int trailingZeros = -this.exponent - this.digits;
            int zerotail = 0;
            if (trailingZeros > 0) {
                zz = this.zeros(trailingZeros);
                frac.append(zz).append(this.mantissa);
            } else {
                String s = Long.toString(this.mantissa).substring(Math.abs(trailingZeros));
                frac.append(s);
                zerotail = this.digits - (s.length() - trailingZeros);
            }
            if (zerotail > 0) {
                zz = this.zeros(zerotail);
                frac.append(zz);
            }
            parts[1] = frac.toString();
        }
        if (this.negative) {
            parts[0] = "-" + parts[0];
        }
        return parts;
    }

    private char[] zeros(int count) {
        char[] zz = new char[count];
        Arrays.fill(zz, '0');
        return zz;
    }

    protected boolean formatExponential(double x, int ndigits) {
        boolean magchg = false;
        this.exponent = this.magnitude - ndigits + 1;
        this.digits = ndigits;
        double factor = Math.pow(10.0, -this.exponent);
        this.mantissa = Math.abs(Math.round(x * factor));
        if (ExpDouble.orderOfMagnitude(this.mantissa) >= this.digits) {
            this.mantissa /= 10L;
            ++this.exponent;
            ++this.magnitude;
            magchg = true;
        }
        if (x < 0.0) {
            this.negative = true;
        }
        return magchg;
    }

    public static int orderOfMagnitude(double x) {
        if (x == 0.0) {
            return -2147483647;
        }
        x = Math.abs(x);
        int magnitude = (int)(Math.log(x + 1.0E-12) / log10);
        if (x < 1.0) {
            --magnitude;
        }
        return magnitude;
    }
}

