/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.Arrays;
import org.knowceans.util.ExpDouble;

public class DoubleFormat {
    public static void main(String[] args) {
        DoubleFormat.run();
    }

    private static void run() {
        double[] a = new double[]{1.02298763E7, 1022.9876, 0.9876, 9.876E-5, 0.0987678, 99.987678, 9.87604E9, 9.976E10};
        int i = 12;
        while (i > 5) {
            System.out.println("\nlength = " + i + " : ");
            int j = 0;
            while (j < a.length) {
                System.out.println("[" + DoubleFormat.format(a[j], 6, i) + "] <= (" + a[j] + ")");
                System.out.println("[" + DoubleFormat.format(-a[j], 6, i) + "] <= (" + -a[j] + ")");
                ++j;
            }
            --i;
        }
    }

    public static double format(double x, int ndigits) {
        int magnitude = ExpDouble.orderOfMagnitude(x);
        double factor = Math.pow(10.0, ndigits - 1 - magnitude);
        double y = (double)Math.round(x * factor) / factor;
        return y;
    }

    static String format(double x, int ndigits, int strlen) {
        String s = null;
        boolean leftalign = false;
        if (strlen < 0) {
            strlen = -strlen;
            leftalign = true;
        }
        if (strlen < 5) {
            throw new IllegalArgumentException("Cannot use yet abs(strlen) < 5");
        }
        int pad = 0;
        ExpDouble d = new ExpDouble(x, ndigits);
        int len = d.strlen();
        pad = strlen - len;
        if (pad >= 0) {
            s = d.toString();
        } else {
            if (d.exponent < 0) {
                int newdigits = d.digits - -pad;
                if (newdigits > 0) {
                    boolean plusone = d.round(newdigits);
                    if (plusone && newdigits > 1) {
                        d.round(newdigits - 1);
                    } else {
                        s = DoubleFormat.exponentialNotation(d, strlen);
                    }
                    s = d.toString();
                } else {
                    s = DoubleFormat.exponentialNotation(d, strlen);
                }
            } else {
                s = DoubleFormat.exponentialNotation(d, strlen);
            }
            pad = strlen - s.length();
        }
        String spc = DoubleFormat.space(Math.max(0, pad));
        if (leftalign) {
            return String.valueOf(s) + spc;
        }
        return String.valueOf(spc) + s;
    }

    private static String exponentialNotation(ExpDouble d, int strlen) {
        int diff;
        int len = d.strlenexp();
        int minlen = d.minstrlenexp();
        if (minlen > strlen) {
            char[] cc = new char[strlen];
            if (d.exponent >= 0) {
                Arrays.fill(cc, '>');
            } else {
                Arrays.fill(cc, '<');
            }
            String string = new String(cc);
        }
        if ((diff = strlen - len) == -1) {
            d.round(d.digits + diff);
        } else {
            d.round(1);
        }
        String s = d.toExpString();
        return s;
    }

    private static String space(int pad) {
        char[] ch = new char[pad];
        Arrays.fill(ch, ' ');
        String spc = new String(ch);
        return spc;
    }
}

