/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.util.Random;

public class CokusRandom
extends Random {
    private static final long serialVersionUID = 3256726169322797365L;
    public static final long DEFAULTSEED = 4357L;
    public static int N = 624;
    public static int M = 397;
    public static long K = 2567483615L;
    long[] state = new long[N + 1];
    int next;
    int left = -1;
    protected boolean haveNextNextGaussian = false;
    protected double nextNextGaussian;
    public double lastRand;

    public static void main(String[] args) {
        CokusRandom r = new CokusRandom(4357L);
        int i = 0;
        while (i < 50) {
            System.out.println(r.nextDouble());
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 50) {
            System.out.println(r.randDouble());
            ++i;
        }
    }

    public CokusRandom() {
        this(4357L);
    }

    public CokusRandom(long i) {
        this.setSeed(i);
    }

    protected long hiBit(long u) {
        return u & 0x80000000L;
    }

    protected long loBit(long u) {
        return u & 1L;
    }

    protected static long loBits(long u) {
        return u & Integer.MAX_VALUE;
    }

    protected long mixBits(long u, long v) {
        return this.hiBit(u) | CokusRandom.loBits(v);
    }

    @Override
    protected int next(int bits) {
        int a = this.next();
        return a >>> 32 - bits;
    }

    public int next() {
        if (--this.left < 0) {
            return this.reload();
        }
        long y = this.state[this.next++];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        return (int)(y ^ y >> 18);
    }

    public long nextUnsignedInt() {
        return (long)this.next() & 0xFFFFFFFFL;
    }

    public double randDouble() {
        return (double)((long)this.next() & 0xFFFFFFFFL) / 4.294967296E9;
    }

    @Override
    public void setSeed(long seed) {
        long x = (seed | 1L) & 0xFFFFFFFFL;
        if (this.state == null) {
            this.state = new long[N + 1];
        }
        long[] s = this.state;
        int si = 0;
        this.left = 0;
        s[si++] = x;
        int j = N;
        while (j > 0) {
            s[si] = x *= 69069L;
            int n = si++;
            s[n] = s[n] & 0xFFFFFFFFL;
            --j;
        }
    }

    public int reload() {
        int p0 = 0;
        int p2 = 2;
        int pM = M;
        if (this.left < -1) {
            this.setSeed(4357L);
        }
        this.left = N - 1;
        this.next = 1;
        long s0 = this.state[0];
        long s1 = this.state[1];
        int j = N - M + 1;
        while (--j != 0) {
            this.state[p0++] = this.state[pM++] ^ this.mixBits(s0, s1) >> 1 ^ (this.loBit(s1) != 0L ? K : 0L);
            s0 = s1;
            s1 = this.state[p2++];
        }
        pM = 0;
        j = M;
        while (--j != 0) {
            this.state[p0++] = this.state[pM++] ^ this.mixBits(s0, s1) >> 1 ^ (this.loBit(s1) != 0L ? K : 0L);
            s0 = s1;
            s1 = this.state[p2++];
        }
        s1 = this.state[0];
        this.state[p0] = this.state[pM] ^ this.mixBits(s0, s1) >> 1 ^ (this.loBit(s1) != 0L ? K : 0L);
        s1 ^= s1 >> 11;
        s1 ^= s1 << 7 & 0x9D2C5680L;
        s1 ^= s1 << 15 & 0xEFC60000L;
        return (int)(s1 ^ s1 >> 18);
    }

    @Override
    public double nextDouble() {
        return this.randDouble();
    }

    @Override
    public boolean nextBoolean() {
        return this.randDouble() >= 0.5;
    }

    @Override
    public float nextFloat() {
        return (float)this.randDouble();
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.randDouble() - 1.0) * v1 + (v2 = 2.0 * this.randDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    @Override
    public int nextInt() {
        return this.next() - Integer.MIN_VALUE;
    }

    public long nextUnsignedLong() {
        return ((long)this.next() << 32) + (long)this.next();
    }

    @Override
    public long nextLong() {
        return this.nextUnsignedLong() - Long.MIN_VALUE;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int numRequested = bytes.length;
        int numGot = 0;
        int rnd = 0;
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= numRequested) continue block0;
                if (numGot == numRequested) {
                    return;
                }
                rnd = i == 0 ? this.next() : rnd >> 8;
                bytes[numGot++] = (byte)rnd;
                ++i;
            }
            break;
        }
    }

    @Override
    public int nextInt(int n) {
        return (int)((double)n * this.randDouble());
    }
}

