/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.knowceans.util.MayaShades;
import org.knowceans.util.Vectors;

public class ArrayIo {
    static NumberFormat nf = new DecimalFormat("0.00000");

    public static int[][] loadBinaryIntMatrix(String filename) {
        int[][] a = null;
        int i = 0;
        int j = 0;
        try {
            DataInputStream dis = ArrayIo.openInputStream(filename);
            int m = dis.readInt();
            int n = dis.readInt();
            a = new int[m][n];
            i = 0;
            while (i < m) {
                j = 0;
                while (j < n) {
                    a[i][j] = dis.readInt();
                    ++j;
                }
                ++i;
            }
            ArrayIo.closeInputStream(dis);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(i) + " " + j);
            e.printStackTrace();
        }
        return a;
    }

    public static double[][] loadBinaryMatrix(String filename) {
        double[][] a = null;
        int i = 0;
        int j = 0;
        try {
            DataInputStream dis = ArrayIo.openInputStream(filename);
            int m = dis.readInt();
            int n = dis.readInt();
            a = new double[m][n];
            i = 0;
            while (i < m) {
                j = 0;
                while (j < n) {
                    a[i][j] = dis.readFloat();
                    ++j;
                }
                ++i;
            }
            ArrayIo.closeInputStream(dis);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(i) + " " + j);
            e.printStackTrace();
        }
        return a;
    }

    public static void saveBinaryIntMatrix(String filename, int[][] a) {
        int i = 0;
        int j = 0;
        try {
            DataOutputStream dos = ArrayIo.openOutputStream(filename);
            dos.writeInt(a.length);
            dos.writeInt(a[0].length);
            i = 0;
            while (i < a.length) {
                j = 0;
                while (j < a[0].length) {
                    dos.writeInt(a[i][j]);
                    ++j;
                }
                ++i;
            }
            ArrayIo.closeOutputStream(dos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(String.valueOf(i) + " " + j);
            e.printStackTrace();
        }
    }

    public static void saveBinaryMatrix(String filename, double[][] a) {
        int i = 0;
        int j = 0;
        try {
            DataOutputStream dos = ArrayIo.openOutputStream(filename);
            dos.writeInt(a.length);
            dos.writeInt(a[0].length);
            i = 0;
            while (i < a.length) {
                j = 0;
                while (j < a[0].length) {
                    dos.writeFloat((float)a[i][j]);
                    ++j;
                }
                ++i;
            }
            ArrayIo.closeOutputStream(dos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(String.valueOf(i) + " " + j);
            e.printStackTrace();
        }
    }

    public static Object read(DataInputStream is, Object type) throws IOException {
        if (type instanceof double[][][]) {
            return ArrayIo.readDoubleTensor(is);
        }
        if (type instanceof double[][]) {
            return ArrayIo.readDoubleMatrix(is);
        }
        if (type instanceof double[]) {
            return ArrayIo.readDoubleVector(is);
        }
        if (type instanceof float[][]) {
            return ArrayIo.readFloatMatrix(is);
        }
        if (type instanceof float[]) {
            return ArrayIo.readFloatVector(is);
        }
        if (type instanceof int[][]) {
            return ArrayIo.readIntMatrix(is);
        }
        if (type instanceof int[]) {
            return ArrayIo.readIntVector(is);
        }
        return null;
    }

    public static int[][] readIntMatrix(DataInputStream bw) throws IOException {
        int rows = bw.readInt();
        int[][] matrix = new int[rows][];
        int i = 0;
        while (i < rows) {
            matrix[i] = ArrayIo.readIntVector(bw);
            ++i;
        }
        return matrix;
    }

    public static int[] readIntVector(DataInputStream bw) throws IOException {
        int length = bw.readInt();
        int[] vector = new int[length];
        int i = 0;
        while (i < length) {
            vector[i] = bw.readInt();
            ++i;
        }
        return vector;
    }

    public static double[][][] readDoubleTensor(DataInputStream bw) throws IOException {
        int slices = bw.readInt();
        double[][][] tensor = new double[slices][][];
        int i = 0;
        while (i < slices) {
            tensor[i] = ArrayIo.readDoubleMatrix(bw);
            ++i;
        }
        return tensor;
    }

    public static double[][] readDoubleMatrix(DataInputStream bw) throws IOException {
        int rows = bw.readInt();
        double[][] matrix = new double[rows][];
        int i = 0;
        while (i < rows) {
            matrix[i] = ArrayIo.readDoubleVector(bw);
            ++i;
        }
        return matrix;
    }

    public static double[] readDoubleVector(DataInputStream bw) throws IOException {
        int length = bw.readInt();
        double[] vector = new double[length];
        int i = 0;
        while (i < length) {
            vector[i] = bw.readDouble();
            ++i;
        }
        return vector;
    }

    public static float[][] readFloatMatrix(DataInputStream bw) throws IOException {
        int rows = bw.readInt();
        float[][] matrix = new float[rows][];
        int i = 0;
        while (i < rows) {
            matrix[i] = ArrayIo.readFloatVector(bw);
            ++i;
        }
        return matrix;
    }

    public static float[] readFloatVector(DataInputStream bw) throws IOException {
        int length = bw.readInt();
        float[] vector = new float[length];
        int i = 0;
        while (i < length) {
            vector[i] = bw.readFloat();
            ++i;
        }
        return vector;
    }

    public static void write(DataOutputStream os, Object data) throws IOException {
        if (data instanceof double[][][]) {
            ArrayIo.writeDoubleTensor(os, (double[][][])data);
        } else if (data instanceof double[][]) {
            ArrayIo.writeDoubleMatrix(os, (double[][])data);
        } else if (data instanceof double[]) {
            ArrayIo.writeDoubleVector(os, (double[])data);
        } else if (data instanceof float[][]) {
            ArrayIo.writeFloatMatrix(os, (float[][])data);
        } else if (data instanceof float[]) {
            ArrayIo.writeFloatVector(os, (float[])data);
        } else if (data instanceof int[][]) {
            ArrayIo.writeIntMatrix(os, (int[][])data);
        } else if (data instanceof int[]) {
            ArrayIo.writeIntVector(os, (int[])data);
        }
    }

    public static void writeIntMatrix(DataOutputStream bw, int[][] matrix) throws IOException {
        bw.writeInt(matrix.length);
        int i = 0;
        while (i < matrix.length) {
            ArrayIo.writeIntVector(bw, matrix[i]);
            ++i;
        }
    }

    public static void writeIntVector(DataOutputStream bw, int[] vector) throws IOException {
        bw.writeInt(vector.length);
        int i = 0;
        while (i < vector.length) {
            bw.writeInt(vector[i]);
            ++i;
        }
    }

    public static void writeDoubleTensor(DataOutputStream bw, double[][][] tensor) throws IOException {
        bw.writeInt(tensor.length);
        int r = 0;
        while (r < tensor.length) {
            ArrayIo.writeDoubleMatrix(bw, tensor[r]);
            ++r;
        }
    }

    public static void writeDoubleMatrix(DataOutputStream bw, double[][] matrix) throws IOException {
        bw.writeInt(matrix.length);
        int i = 0;
        while (i < matrix.length) {
            ArrayIo.writeDoubleVector(bw, matrix[i]);
            ++i;
        }
    }

    public static void writeDoubleVector(DataOutputStream bw, double[] vector) throws IOException {
        bw.writeInt(vector.length);
        int i = 0;
        while (i < vector.length) {
            bw.writeDouble(vector[i]);
            ++i;
        }
    }

    public static void writeFloatMatrix(DataOutputStream bw, float[][] matrix) throws IOException {
        bw.writeInt(matrix.length);
        int i = 0;
        while (i < matrix.length) {
            ArrayIo.writeFloatVector(bw, matrix[i]);
            ++i;
        }
    }

    public static void writeFloatVector(DataOutputStream bw, float[] vector) throws IOException {
        bw.writeInt(vector.length);
        int i = 0;
        while (i < vector.length) {
            bw.writeFloat(vector[i]);
            ++i;
        }
    }

    public static String padSpace(String s, int length) {
        if (s == null) {
            s = "[null]";
        }
        StringBuffer b = new StringBuffer(s);
        int i = 0;
        while (i < length - s.length()) {
            b.append(' ');
            ++i;
        }
        return b.substring(0, length);
    }

    public static String formatDouble(double d) {
        String x = nf.format(d);
        return x;
    }

    public static double[][] loadAscii(String filename) {
        Vector<double[]> a = new Vector<double[]>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                String[] fields = line.trim().split(" ");
                double[] row = new double[fields.length];
                int i = 0;
                while (i < fields.length) {
                    row[i] = Double.parseDouble(fields[i]);
                    ++i;
                }
                a.add(row);
            }
            br.close();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (double[][])a.toArray((T[])new double[0][0]);
    }

    public static void saveAscii(String filename, double[][] a) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            int row = 0;
            while (row < a.length) {
                int col = 0;
                while (col < a[0].length) {
                    if (col > 0) {
                        bw.write(32);
                    }
                    bw.write(ArrayIo.formatDouble(a[row][col]));
                    ++col;
                }
                bw.newLine();
                ++row;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveTransposedAscii(String filename, double[][] a) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            int col = 0;
            while (col < a[0].length) {
                int row = 0;
                while (row < a.length) {
                    if (row > 0) {
                        bw.write(32);
                    }
                    bw.write(ArrayIo.formatDouble(a[row][col]));
                    ++row;
                }
                bw.newLine();
                ++col;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static DataOutputStream openOutputStream(String filename) throws FileNotFoundException, IOException {
        DataOutputStream dos = null;
        if (filename.endsWith(".zip")) {
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(filename));
            String name = new File(filename).getName();
            zip.putNextEntry(new ZipEntry(String.valueOf(name.substring(0, name.length() - 3)) + "bin"));
            dos = new DataOutputStream(new BufferedOutputStream(zip));
        } else {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        }
        return dos;
    }

    public static void closeOutputStream(DataOutputStream dos) throws IOException {
        dos.close();
    }

    public static DataInputStream openInputStream(String filename) throws IOException, FileNotFoundException {
        DataInputStream dis = null;
        if (filename.endsWith(".zip")) {
            ZipFile f = new ZipFile(filename);
            String name = new File(filename).getName();
            dis = new DataInputStream(new BufferedInputStream(f.getInputStream(f.getEntry(String.valueOf(name.substring(0, name.length() - 3)) + "bin"))));
        } else {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        }
        return dis;
    }

    public static void closeInputStream(DataInputStream dis) throws IOException {
        dis.close();
    }

    public static void saveShades(String filename, double[][] a) {
        double[] maxs = new double[a.length];
        int i = 0;
        while (i < a.length) {
            maxs[i] = Vectors.max(a[i]);
            ++i;
        }
        double maxx = Vectors.max(maxs);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            bw.write("# [:::::] = " + maxx + ", [.    ] = " + maxx / 10.0);
            bw.newLine();
            int row = 0;
            while (row < a.length) {
                int col = 0;
                while (col < a[row].length) {
                    if (col > 0) {
                        bw.write(32);
                    }
                    bw.write(MayaShades.shadeDouble(a[row][col], maxx));
                    ++col;
                }
                bw.newLine();
                ++row;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveTransposedShades(String filename, double[][] a) {
        double[] maxs = new double[a.length];
        int i = 0;
        while (i < a.length) {
            maxs[i] = Vectors.max(a[i]);
            ++i;
        }
        double maxx = Vectors.max(maxs);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            bw.write("# [:::::] = " + maxx + ", [.    ] = " + maxx / 10.0);
            bw.newLine();
            int col = 0;
            while (col < a[0].length) {
                int row = 0;
                while (row < a.length) {
                    if (row > 0) {
                        bw.write(32);
                    }
                    bw.write(MayaShades.shadeDouble(a[row][col], maxx));
                    ++row;
                }
                bw.newLine();
                ++col;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

