/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.util;

public abstract class ArmSampler {
    Object params;
    public static final int DEREF = 0;
    public static final double XEPS = 1.0E-5;
    public static final double YEPS = 0.1;
    public static final double EYEPS = 0.001;
    public static final double YCEIL = 50.0;

    public abstract double logpdf(double var1, Object var3);

    public double armsSimple(Object params, int ninit, double[] xl, double[] xr, boolean dometrop, double[] xprev) throws Exception {
        double[] xinit = new double[ninit];
        double[] convex = new double[]{1.0};
        double[] qcent = null;
        double[] xcent = null;
        int npoint = 100;
        int nsamp = 1;
        int ncent = 0;
        int[] neval = new int[1];
        double[] xsamp = new double[1];
        int i = 0;
        while (i < ninit) {
            xinit[i] = xl[0] + ((double)i + 1.0) * (xr[0] - xl[0]) / ((double)ninit + 1.0);
            ++i;
        }
        this.arms(params, xinit, ninit, xl, xr, convex, npoint, dometrop, xprev, xsamp, nsamp, qcent, xcent, ncent, neval);
        return xsamp[0];
    }

    public double[] arms(Object params, double[] xinit, int ninit, double[] xl, double[] xr, double[] convex, int npoint, boolean dometrop, double[] xprev, double[] xsamp, int nsamp, double[] qcent, double[] xcent, int ncent, int[] neval) throws Exception {
        this.params = params;
        Point pwork = new Point();
        int msamp = 0;
        int i = 0;
        while (i < ncent) {
            if (qcent[i] < 0.0 || qcent[i] > 100.0) {
                throw new Exception("percentage requesting centile is out of range");
            }
            ++i;
        }
        Envelope env = new Envelope();
        Metropolis metrop = new Metropolis();
        metrop.on = dometrop;
        this.initial(xinit, ninit, xl[0], xr[0], npoint, env, convex, neval, metrop);
        if (metrop.on) {
            if (xprev[0] < xl[0] || xprev[0] > xr[0]) {
                throw new Exception("previous markov chain iterate out of range");
            }
            metrop.xprev = xprev[0];
            metrop.yprev = this.perfunc(env, xprev[0]);
        }
        do {
            this.sample(env, pwork);
            i = this.test(env, pwork, metrop);
            if (i == 1) {
                xsamp[msamp++] = pwork.x;
                continue;
            }
            if (i == 0) continue;
            throw new Exception("envelope error - violation without metropolis");
        } while (msamp < nsamp);
        i = 0;
        while (i < ncent) {
            this.invert(qcent[i] / 100.0, env, pwork);
            xcent[i] = pwork.x;
            ++i;
        }
        return xsamp;
    }

    int initial(double[] xinit, int ninit, double xl, double xr, int npoint, Envelope env, double[] convex, int[] neval, Metropolis metrop) throws Exception {
        if (ninit < 3) {
            throw new Exception("too few initial points");
        }
        int mpoint = 2 * ninit + 1;
        if (npoint < mpoint) {
            throw new Exception("too many initial points");
        }
        if (xinit[0] <= xl || xinit[ninit - 1] >= xr) {
            throw new Exception("initial points do not satisfy bounds ");
        }
        int i = 1;
        while (i < ninit) {
            if (xinit[i] <= xinit[i - 1]) {
                throw new Exception("data not ordered");
            }
            ++i;
        }
        if (convex[0] < 0.0) {
            throw new Exception("negative convexity parameter");
        }
        env.convex = convex;
        env.neval = neval;
        env.neval[0] = 0;
        env.npoint = npoint;
        Point[] q = env.p = new Point[npoint];
        q[0] = new Point();
        q[0].x = xl;
        q[0].f = 0;
        q[0].pl = null;
        q[0].pr = q[1];
        int j = 1;
        int k = 0;
        while (j < mpoint - 1) {
            q[j] = new Point();
            if (j % 2 != 0) {
                q[j].x = xinit[k++];
                q[j].y = this.perfunc(env, q[j].x);
                q[j].f = 1;
            } else {
                q[j].f = 0;
            }
            q[j].pl = q[j - 1];
            q[j - 1].pr = q[j];
            ++j;
        }
        q[j] = new Point();
        q[j].x = xr;
        q[j].f = 0;
        q[j].pl = q[j - 1];
        q[j - 1].pr = q[j];
        q[j].pr = null;
        q = env.p;
        j = 0;
        while (j < mpoint) {
            this.meet(q[j], env, metrop);
            j += 2;
        }
        this.cumulate(env);
        env.cpoint = mpoint;
        return 0;
    }

    void sample(Envelope env, Point p) throws Exception {
        double prob = Math.random();
        this.invert(prob, env, p);
    }

    void invert(double prob, Envelope env, Point p) throws Exception {
        double xl = 0.0;
        double xr = 0.0;
        Point q = env.p[0];
        while (q.pr != null) {
            q = q.pr;
        }
        double u = prob * q.cum;
        while (q.pl.cum > u) {
            q = q.pl;
        }
        p.pl = q.pl;
        p.pr = q;
        p.f = 0;
        p.cum = u;
        double prop = (u - q.pl.cum) / (q.cum - q.pl.cum);
        if (q.pl.x == q.x) {
            p.x = q.x;
            p.y = q.y;
            p.ey = q.ey;
        } else {
            xl = q.pl.x;
            xr = q.x;
            double yl = q.pl.y;
            double yr = q.y;
            double eyl = q.pl.ey;
            double eyr = q.ey;
            if (Math.abs(yr - yl) < 0.1) {
                p.x = Math.abs(eyr - eyl) > 0.001 * Math.abs(eyr + eyl) ? xl + (xr - xl) / (eyr - eyl) * (-eyl + Math.sqrt((1.0 - prop) * eyl * eyl + prop * eyr * eyr)) : xl + (xr - xl) * prop;
                p.ey = (p.x - xl) / (xr - xl) * (eyr - eyl) + eyl;
                p.y = this.logshift(p.ey, env.ymax);
            } else {
                p.x = xl + (xr - xl) / (yr - yl) * (-yl + this.logshift((1.0 - prop) * eyl + prop * eyr, env.ymax));
                p.y = (p.x - xl) / (xr - xl) * (yr - yl) + yl;
                p.ey = this.expshift(p.y, env.ymax);
            }
        }
        if (p.x < xl || p.x > xr) {
            throw new Exception("imprecision yielding point outside interval ");
        }
    }

    int test(Envelope env, Point p, Metropolis metrop) throws Exception {
        Point qr;
        Point ql;
        double u = Math.random() * p.ey;
        double y = this.logshift(u, env.ymax);
        if (!metrop.on && p.pl.pl != null && p.pr.pr != null) {
            ql = p.pl.f != 0 ? p.pl : p.pl.pl;
            qr = p.pr.f != 0 ? p.pr : p.pr.pr;
            double ysqueez = (qr.y * (p.x - ql.x) + ql.y * (qr.x - p.x)) / (qr.x - ql.x);
            if (y <= ysqueez) {
                return 1;
            }
        }
        double ynew = this.perfunc(env, p.x);
        if (!metrop.on || metrop.on && y >= ynew) {
            p.y = ynew;
            p.ey = this.expshift(p.y, env.ymax);
            p.f = 1;
            this.update(env, p, metrop);
            if (y >= ynew) {
                return 0;
            }
            return 1;
        }
        double yold = metrop.yprev;
        ql = env.p[0];
        while (ql.pl != null) {
            ql = ql.pl;
        }
        while (ql.pr.x < metrop.xprev) {
            ql = ql.pr;
        }
        qr = ql.pr;
        double w = (metrop.xprev - ql.x) / (qr.x - ql.x);
        double zold = ql.y + w * (qr.y - ql.y);
        double znew = p.y;
        if (yold < zold) {
            zold = yold;
        }
        if (ynew < znew) {
            znew = ynew;
        }
        if ((w = ynew - znew - yold + zold) > 0.0) {
            w = 0.0;
        }
        w = w > -50.0 ? Math.exp(w) : 0.0;
        u = Math.random();
        if (u > w) {
            p.x = metrop.xprev;
            p.y = metrop.yprev;
            p.ey = this.expshift(p.y, env.ymax);
            p.f = 1;
            p.pl = ql;
            p.pr = qr;
        } else {
            metrop.xprev = p.x;
            metrop.yprev = ynew;
        }
        return 1;
    }

    int update(Envelope env, Point p, Metropolis metrop) throws Exception {
        if (p.f == 0 || env.cpoint > env.npoint - 2) {
            return 0;
        }
        Point q = new Point();
        q.x = p.x;
        q.y = p.y;
        q.f = 1;
        Point m = new Point();
        m.f = 0;
        if (p.pl.f != 0 && p.pr.f == 0) {
            m.pl = p.pl;
            m.pr = q;
            q.pl = m;
            q.pr = p.pr;
            m.pl.pr = m;
            q.pr.pl = q;
        } else if (p.pl.f == 0 && p.pr.f != 0) {
            m.pr = p.pr;
            m.pl = q;
            q.pr = m;
            q.pl = p.pl;
            m.pr.pl = m;
            q.pl.pr = q;
        } else {
            throw new Exception("unknown error");
        }
        Point ql = q.pl.pl != null ? q.pl.pl : q.pl;
        Point qr = q.pr.pr != null ? q.pr.pr : q.pr;
        if (q.x < 0.99999 * ql.x + 1.0E-5 * qr.x) {
            q.x = 0.99999 * ql.x + 1.0E-5 * qr.x;
            q.y = this.perfunc(env, q.x);
        } else if (q.x > 1.0E-5 * ql.x + 0.99999 * qr.x) {
            q.x = 1.0E-5 * ql.x + 0.99999 * qr.x;
            q.y = this.perfunc(env, q.x);
        }
        this.meet(q.pl, env, metrop);
        this.meet(q.pr, env, metrop);
        if (q.pl.pl != null) {
            this.meet(q.pl.pl.pl, env, metrop);
        }
        if (q.pr.pr != null) {
            this.meet(q.pr.pr.pr, env, metrop);
        }
        this.cumulate(env);
        return 0;
    }

    void cumulate(Envelope env) throws Exception {
        Point qlmost = env.p[0];
        while (qlmost.pl != null) {
            qlmost = qlmost.pl;
        }
        env.ymax = qlmost.y;
        Point q = qlmost.pr;
        while (q != null) {
            if (q.y > env.ymax) {
                env.ymax = q.y;
            }
            q = q.pr;
        }
        q = qlmost;
        while (q != null) {
            q.ey = this.expshift(q.y, env.ymax);
            q = q.pr;
        }
        qlmost.cum = 0.0;
        q = qlmost.pr;
        while (q != null) {
            q.cum = q.pl.cum + this.area(q);
            q = q.pr;
        }
    }

    int meet(Point q, Envelope env, Metropolis metrop) throws Exception {
        boolean irl;
        boolean ir;
        boolean il;
        double gl = 0.0;
        double gr = 0.0;
        double grl = 0.0;
        double dl = 0.0;
        double dr = 0.0;
        if (q.f != 0) {
            throw new Exception("this is not an intersection point");
        }
        if (q.pl != null && q.pl.pl.pl != null) {
            gl = (q.pl.y - q.pl.pl.pl.y) / (q.pl.x - q.pl.pl.pl.x);
            il = true;
        } else {
            il = false;
        }
        if (q.pr != null && q.pr.pr.pr != null) {
            gr = (q.pr.y - q.pr.pr.pr.y) / (q.pr.x - q.pr.pr.pr.x);
            ir = true;
        } else {
            ir = false;
        }
        if (q.pl != null && q.pr != null) {
            grl = (q.pr.y - q.pl.y) / (q.pr.x - q.pl.x);
            irl = true;
        } else {
            irl = false;
        }
        if (irl && il && gl < grl) {
            if (!metrop.on) {
                throw new Exception("convex on left: envelope violation without metropolis ");
            }
            gl += (1.0 + env.convex[0]) * (grl - gl);
        }
        if (irl && ir && gr > grl) {
            if (!metrop.on) {
                throw new Exception("convex on right: envelope violation without metropolis ");
            }
            gr += (1.0 + env.convex[0]) * (grl - gr);
        }
        if (il && irl && (dr = (gl - grl) * (q.pr.x - q.pl.x)) < 0.1) {
            dr = 0.1;
        }
        if (ir && irl && (dl = (grl - gr) * (q.pr.x - q.pl.x)) < 0.1) {
            dl = 0.1;
        }
        if (il && ir && irl) {
            q.x = (dl * q.pr.x + dr * q.pl.x) / (dl + dr);
            q.y = (dl * q.pr.y + dr * q.pl.y + dl * dr) / (dl + dr);
        } else if (il && irl) {
            q.x = q.pr.x;
            q.y = q.pr.y + dr;
        } else if (ir && irl) {
            q.x = q.pl.x;
            q.y = q.pl.y + dl;
        } else if (il) {
            q.y = q.pl.y + gl * (q.x - q.pl.x);
        } else if (ir) {
            q.y = q.pr.y - gr * (q.pr.x - q.x);
        } else {
            throw new Exception("gradient on neither side - should be impossible ");
        }
        if (q.pl != null && q.x < q.pl.x || q.pr != null && q.x > q.pr.x) {
            throw new Exception("intersection point outside interval (through imprecision)");
        }
        return 0;
    }

    double area(Point q) throws Exception {
        if (q.pl == null) {
            throw new Exception("this is leftmost point in envelope");
        }
        double a = q.pl.x == q.x ? 0.0 : (Math.abs(q.y - q.pl.y) < 0.1 ? 0.5 * (q.ey + q.pl.ey) * (q.x - q.pl.x) : (q.ey - q.pl.ey) / (q.y - q.pl.y) * (q.x - q.pl.x));
        return a;
    }

    double expshift(double y, double y0) {
        if (y - y0 > -100.0) {
            return Math.exp(y - y0 + 50.0);
        }
        return 0.0;
    }

    double logshift(double y, double y0) {
        return Math.log(y) + y0 - 50.0;
    }

    double perfunc(Envelope env, double x) {
        double y = this.logpdf(x, this.params);
        env.neval[0] = env.neval[0] + 1;
        return y;
    }

    class Envelope {
        int cpoint;
        int npoint;
        int[] neval;
        double ymax;
        Point[] p;
        double[] convex;

        Envelope() {
        }
    }

    class Metropolis {
        boolean on;
        double xprev;
        double yprev;

        Metropolis() {
        }
    }

    class Point {
        double x;
        double y;
        double ey;
        double cum;
        int f;
        Point pl;
        Point pr;

        Point() {
        }
    }
}

