/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.topics.simple.sandbox;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListSet;
import org.knowceans.corpus.NumCorpus;
import org.knowceans.corpus.VisCorpus;
import org.knowceans.topics.simple.ISimpleGibbs;
import org.knowceans.topics.simple.ISimplePpx;
import org.knowceans.topics.simple.ISimpleQueryGibbs;
import org.knowceans.topics.simple.LdaTopics;
import org.knowceans.topics.simple.TopicMatrixPanel;
import org.knowceans.util.ArrayIo;
import org.knowceans.util.ArrayUtils;
import org.knowceans.util.CokusRandom;
import org.knowceans.util.DirichletEstimation;
import org.knowceans.util.IndexQuickSort;
import org.knowceans.util.ParallelFor;
import org.knowceans.util.RandomSamplers;
import org.knowceans.util.StopWatch;
import org.knowceans.util.Vectors;

public class IldaGibbsPar
implements ISimpleGibbs,
ISimpleQueryGibbs,
ISimplePpx {
    private static TopicMatrixPanel vis;
    private int[][] w;
    private int[][] wq;
    private SortedSet<Integer> kgaps;
    private List<Integer> kactive;
    private List<Integer>[] nmk;
    private int[][] nmkq;
    private List<int[]> nkt;
    private List<Integer> nk;
    private double[][] phi;
    private int[][] z;
    private int[][] zq;
    private double[][] pp;
    public final int ppstep = 10;
    private double alpha;
    private ArrayList<Double> tau;
    private double beta;
    private double gamma;
    double aalpha = 5.0;
    double balpha = 0.1;
    double abeta = 0.1;
    double bbeta = 0.1;
    double agamma = 5.0;
    double bgamma = 0.1;
    int R = 10;
    private double T;
    int P;
    private Random[] rand;
    RandomSamplers[] samp;
    private int K;
    private int M;
    private int Mq;
    private int Wq;
    private int V;
    private boolean inited = false;
    private boolean fixedK = false;
    private boolean fixedHyper = false;

    public static void main(String[] args) {
        NumCorpus corpus;
        int niter = 1500;
        int niterq = 10;
        String filebase = "nips/nips";
        boolean usefile = false;
        boolean display = true;
        CokusRandom rand = new CokusRandom(56567651L);
        if (usefile) {
            corpus = new NumCorpus(String.valueOf(filebase) + ".corpus");
            if (display) {
                vis = new TopicMatrixPanel(900, 400, (int)Math.sqrt(corpus.getNumTerms()), 1);
            }
        } else {
            int K = 10;
            corpus = VisCorpus.generateLdaCorpus(K, 1000, 200);
            if (display) {
                vis = new TopicMatrixPanel(900, 400, K, 300 / K);
            }
        }
        corpus.split(10, 2, rand);
        NumCorpus train = (NumCorpus)corpus.getTrainCorpus();
        NumCorpus test = (NumCorpus)corpus.getTestCorpus();
        int[][] w = train.getDocWords(rand);
        int[][] wq = test.getDocWords(rand);
        int K0 = 0;
        int V = corpus.getNumTerms();
        double alpha = 1.0;
        double beta = 0.1;
        double gamma = 1.5;
        IldaGibbsPar gs = new IldaGibbsPar(w, wq, K0, V, alpha, beta, gamma, rand);
        gs.init();
        System.out.println("initialised");
        System.out.println(gs);
        gs.initq();
        gs.runq(niterq);
        System.out.println("perplexity = " + gs.ppx());
        StopWatch.start();
        System.out.println("starting Gibbs sampler with " + niter + " iterations");
        gs.run(niter);
        System.out.println(StopWatch.format(StopWatch.stop()));
        gs.initq();
        gs.runq(niterq);
        System.out.println("perplexity = " + gs.ppx());
        System.out.println(gs);
        gs.packTopics();
        System.out.println("finished");
        System.out.println(gs);
        if (!usefile) {
            try {
                PrintStream bw = new PrintStream(String.valueOf(filebase) + ".ilda.result");
                gs.print(bw, filebase, corpus.getOrigDocIds()[0], train.getNumWords());
                bw.close();
                System.out.println("done");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void print(PrintStream out, String filebase, int[] docids, int W) {
        this.phi = new double[this.K][this.V];
        double[][] theta = new double[this.M][this.K];
        int k = 0;
        while (k < this.K) {
            int t = 0;
            while (t < this.V) {
                this.phi[k][t] = ((double)this.nkt.get(k)[t] + this.beta) / ((double)this.nk.get(k).intValue() + this.beta * (double)this.V);
                ++t;
            }
            ++k;
        }
        int m = 0;
        while (m < this.M) {
            int k2 = 0;
            while (k2 < this.K) {
                theta[m][k2] = ((double)this.nmk[m].get(k2).intValue() + this.alpha) / ((double)this.w[m].length + this.alpha * (double)this.K);
                ++k2;
            }
            ++m;
        }
        LdaTopics lt = new LdaTopics(filebase, theta, this.phi);
        int m2 = 0;
        while (m2 < this.M) {
            out.println(lt.printDocument(m2, docids[m2], 10, false, true));
            ++m2;
        }
        int[] kk = IndexQuickSort.sort(this.nk);
        IndexQuickSort.reverse(kk);
        int k3 = 0;
        while (k3 < this.K) {
            out.println(String.format("%d (%2.5f / %d): %s", k3, (double)this.nk.get(kk[k3]).intValue() / (double)W * (double)this.K, this.K, lt.printTopic(kk[k3], 20)));
            ++k3;
        }
        ArrayIo.saveBinaryMatrix(String.valueOf(filebase) + ".ilda.theta.zip", theta);
        ArrayIo.saveBinaryMatrix(String.valueOf(filebase) + ".ilda.phi.zip", this.phi);
    }

    public IldaGibbsPar(int[][] w, int[][] wq, int K, int V, double alpha, double beta, double gamma, Random rand) {
        this.w = w;
        this.wq = wq;
        this.K = K;
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = gamma;
        if (gamma == 0.0) {
            this.fixedK = true;
        }
        this.M = w.length;
        this.Mq = wq.length;
        this.V = V;
        this.P = Runtime.getRuntime().availableProcessors();
        this.rand = new CokusRandom[this.P];
        this.samp = new RandomSamplers[this.P];
        int p = 0;
        while (p < this.P) {
            this.rand[p] = new CokusRandom(rand.nextInt());
            this.samp[p] = new RandomSamplers(this.rand[p]);
            ++p;
        }
    }

    @Override
    public void init() {
        this.nmk = new ArrayList[this.M];
        this.nkt = new Vector<int[]>();
        this.nk = new Vector<Integer>();
        this.z = new int[this.M][];
        int m = 0;
        while (m < this.M) {
            this.nmk[m] = new ArrayList<Integer>();
            int k = 0;
            while (k < this.K) {
                this.nmk[m].add(0);
                ++k;
            }
            this.z[m] = new int[this.w[m].length];
            ++m;
        }
        this.kactive = new Vector<Integer>();
        this.kgaps = new ConcurrentSkipListSet<Integer>();
        this.tau = new ArrayList();
        int k = 0;
        while (k < this.K) {
            this.kactive.add(k);
            this.nkt.add(new int[this.V]);
            this.nk.add(0);
            this.tau.add(1.0 / (double)this.K);
            ++k;
        }
        this.tau.add(1.0 / (double)this.K);
        this.pp = new double[this.P][this.K + 10];
        this.run(1);
        if (!this.fixedK) {
            this.updateTau(0);
        }
        this.inited = true;
    }

    @Override
    public void initq() {
        int Kg = this.K + this.kgaps.size();
        this.phi = new double[Kg][this.V];
        int kk = 0;
        while (kk < this.K) {
            int k = this.kactive.get(kk);
            int t = 0;
            while (t < this.V) {
                this.phi[k][t] = ((double)this.nkt.get(k)[t] + this.beta) / ((double)this.nk.get(k).intValue() + (double)this.V * this.beta);
                ++t;
            }
            ++kk;
        }
        this.nmkq = new int[this.Mq][Kg];
        this.zq = new int[this.Mq][];
        this.Wq = 0;
        int m = 0;
        while (m < this.Mq) {
            this.zq[m] = new int[this.wq[m].length];
            int n = 0;
            while (n < this.wq[m].length) {
                int k;
                this.zq[m][n] = k = this.rand[0].nextInt(this.K);
                int[] nArray = this.nmkq[m];
                int n2 = k;
                nArray[n2] = nArray[n2] + 1;
                ++this.Wq;
                ++n;
            }
            ++m;
        }
    }

    @Override
    public void run(int niter) {
        ParallelFor parfor = new ParallelFor(this.P){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(int m, int thread) {
                int n = 0;
                while (n < IldaGibbsPar.this.w[m].length) {
                    int[] nArray;
                    int k;
                    int kold = -1;
                    int t = IldaGibbsPar.this.w[m][n];
                    if (IldaGibbsPar.this.inited) {
                        k = IldaGibbsPar.this.z[m][n];
                        IldaGibbsPar.this.nmk[m].set(k, (Integer)IldaGibbsPar.this.nmk[m].get(k) - 1);
                        int[] nArray2 = (int[])IldaGibbsPar.this.nkt.get(k);
                        synchronized (nArray2) {
                            int[] nArray3 = (int[])IldaGibbsPar.this.nkt.get(k);
                            int n2 = t;
                            nArray3[n2] = nArray3[n2] - 1;
                            IldaGibbsPar.this.nk.set(k, (Integer)IldaGibbsPar.this.nk.get(k) - 1);
                        }
                        kold = k;
                    }
                    double psum = 0.0;
                    int kk = 0;
                    while (kk < IldaGibbsPar.this.K) {
                        k = (Integer)IldaGibbsPar.this.kactive.get(kk);
                        ((IldaGibbsPar)IldaGibbsPar.this).pp[thread][kk] = ((double)((Integer)IldaGibbsPar.this.nmk[m].get(k)).intValue() + IldaGibbsPar.this.alpha * (Double)IldaGibbsPar.this.tau.get(k)) * ((double)((int[])IldaGibbsPar.this.nkt.get(k))[t] + IldaGibbsPar.this.beta) / ((double)((Integer)IldaGibbsPar.this.nk.get(k)).intValue() + (double)IldaGibbsPar.this.V * IldaGibbsPar.this.beta);
                        psum += IldaGibbsPar.this.pp[thread][kk];
                        ++kk;
                    }
                    if (!IldaGibbsPar.this.fixedK) {
                        ((IldaGibbsPar)IldaGibbsPar.this).pp[thread][((IldaGibbsPar)IldaGibbsPar.this).K] = IldaGibbsPar.this.alpha * (Double)IldaGibbsPar.this.tau.get(IldaGibbsPar.this.K) / (double)IldaGibbsPar.this.V;
                        psum += IldaGibbsPar.this.pp[thread][IldaGibbsPar.this.K];
                    }
                    double u = IldaGibbsPar.this.rand[thread].nextDouble();
                    u *= psum;
                    psum = 0.0;
                    int kk2 = 0;
                    while (kk2 < IldaGibbsPar.this.K + 1) {
                        if (u <= (psum += IldaGibbsPar.this.pp[thread][kk2])) break;
                        ++kk2;
                    }
                    if (kk2 < IldaGibbsPar.this.K) {
                        ((IldaGibbsPar)IldaGibbsPar.this).z[m][n] = k = ((Integer)IldaGibbsPar.this.kactive.get(kk2)).intValue();
                        IldaGibbsPar.this.nmk[m].set(k, (Integer)IldaGibbsPar.this.nmk[m].get(k) + 1);
                        nArray = (int[])IldaGibbsPar.this.nkt.get(k);
                        synchronized (nArray) {
                            int[] nArray4 = (int[])IldaGibbsPar.this.nkt.get(k);
                            int n3 = t;
                            nArray4[n3] = nArray4[n3] + 1;
                            IldaGibbsPar.this.nk.set(k, (Integer)IldaGibbsPar.this.nk.get(k) + 1);
                        }
                    } else {
                        if (!$assertionsDisabled && IldaGibbsPar.this.fixedK) {
                            throw new AssertionError();
                        }
                        ((IldaGibbsPar)IldaGibbsPar.this).z[m][n] = IldaGibbsPar.this.spawnTopic(thread, m, t);
                        IldaGibbsPar.this.updateTau(thread);
                        System.out.println("K = " + IldaGibbsPar.this.K);
                    }
                    if (IldaGibbsPar.this.inited && (Integer)IldaGibbsPar.this.nk.get(kold) == 0) {
                        nArray = (int[])IldaGibbsPar.this.nkt.get(kold);
                        synchronized (nArray) {
                            IldaGibbsPar.this.kactive.remove((Object)kold);
                            IldaGibbsPar.this.kgaps.add(kold);
                            if (!($assertionsDisabled || Vectors.sum((int[])IldaGibbsPar.this.nkt.get(kold)) == 0 && (Integer)IldaGibbsPar.this.nk.get(kold) == 0 && (Integer)IldaGibbsPar.this.nmk[m].get(kold) == 0)) {
                                throw new AssertionError();
                            }
                            IldaGibbsPar ildaGibbsPar = IldaGibbsPar.this;
                            ildaGibbsPar.K = ildaGibbsPar.K - 1;
                            System.out.println("K = " + IldaGibbsPar.this.K);
                        }
                        IldaGibbsPar.this.updateTau(thread);
                    }
                    ++n;
                }
            }
        };
        int iter = 0;
        while (iter < niter) {
            System.out.println(iter);
            parfor.loop(this.M);
            if (vis != null) {
                vis.setTopics(this.nkt);
            }
            if (!this.fixedK) {
                this.updateTau(0);
            }
            if (iter > 10 && !this.fixedHyper) {
                this.updateHyper();
            }
            ++iter;
        }
        parfor.shutdown();
    }

    @Override
    public void runq(int niter) {
        ParallelFor parfor = new ParallelFor(this.P){

            @Override
            public void process(int m, int thread) {
                int n = 0;
                while (n < IldaGibbsPar.this.wq[m].length) {
                    int k = IldaGibbsPar.this.zq[m][n];
                    int t = IldaGibbsPar.this.wq[m][n];
                    int[] nArray = IldaGibbsPar.this.nmkq[m];
                    int n2 = k;
                    nArray[n2] = nArray[n2] - 1;
                    double psum = 0.0;
                    int kk = 0;
                    while (kk < IldaGibbsPar.this.K) {
                        ((IldaGibbsPar)IldaGibbsPar.this).pp[thread][kk] = ((double)IldaGibbsPar.this.nmkq[m][kk] + IldaGibbsPar.this.alpha) * IldaGibbsPar.this.phi[kk][t];
                        psum += IldaGibbsPar.this.pp[thread][kk];
                        ++kk;
                    }
                    double u = IldaGibbsPar.this.rand[thread].nextDouble() * psum;
                    psum = 0.0;
                    int kk2 = 0;
                    while (kk2 < IldaGibbsPar.this.K) {
                        if (u <= (psum += IldaGibbsPar.this.pp[thread][kk2])) break;
                        ++kk2;
                    }
                    ((IldaGibbsPar)IldaGibbsPar.this).zq[m][n] = kk2;
                    int[] nArray2 = IldaGibbsPar.this.nmkq[m];
                    int n3 = kk2;
                    nArray2[n3] = nArray2[n3] + 1;
                    ++n;
                }
            }
        };
        int iter = 0;
        while (iter < niter) {
            System.out.println(iter);
            parfor.loop(this.Mq);
            ++iter;
        }
        parfor.shutdown();
    }

    private synchronized int spawnTopic(int thread, int m, int t) {
        int k;
        if (this.kgaps.size() > 0) {
            k = this.kgaps.first();
            this.kgaps.remove(k);
            this.kactive.add(k);
            this.nmk[m].set(k, 1);
            this.nkt.get((int)k)[t] = 1;
            this.nk.set(k, 1);
        } else {
            k = this.K;
            int i = 0;
            while (i < this.M) {
                this.nmk[i].add(0);
                ++i;
            }
            this.kactive.add(this.K);
            this.nmk[m].set(this.K, 1);
            this.nkt.add(new int[this.V]);
            this.nkt.get((int)this.K)[t] = 1;
            this.nk.add(1);
            this.tau.add(0.0);
        }
        ++this.K;
        if (this.pp.length <= this.K) {
            double[][] pp2 = new double[this.P][this.K + 10];
            int p = 0;
            while (p < this.P) {
                System.arraycopy(this.pp[p], 0, pp2[p], 0, this.K);
                ++p;
            }
            this.pp = pp2;
        }
        return k;
    }

    public void packTopics() {
        int i;
        int[] knew2k = IndexQuickSort.sort(this.nk);
        IndexQuickSort.reverse(knew2k);
        IndexQuickSort.reorder(this.nk, knew2k);
        IndexQuickSort.reorder(this.nkt, knew2k);
        int i2 = 0;
        while (i2 < this.kgaps.size()) {
            this.nk.remove(this.nk.size() - 1);
            this.nkt.remove(this.nkt.size() - 1);
            ++i2;
        }
        int m = 0;
        while (m < this.M) {
            IndexQuickSort.reorder(this.nmk[m], knew2k);
            i = 0;
            while (i < this.kgaps.size()) {
                this.nmk[m].remove(this.nmk[m].size() - 1);
                ++i;
            }
            ++m;
        }
        this.kgaps.clear();
        int[] k2knew = IndexQuickSort.inverse(knew2k);
        i = 0;
        while (i < this.K) {
            this.kactive.set(i, k2knew[this.kactive.get(i)]);
            ++i;
        }
        int m2 = 0;
        while (m2 < this.M) {
            int n = 0;
            while (n < this.w[m2].length) {
                this.z[m2][n] = k2knew[this.z[m2][n]];
                ++n;
            }
            ++m2;
        }
    }

    private synchronized void updateTau(int thread) {
        double[] mk = new double[this.K + 1];
        int kk = 0;
        while (kk < this.K) {
            int k = this.kactive.get(kk);
            int m = 0;
            while (m < this.M) {
                if (this.nmk[m].get(k) > 1) {
                    int n = kk;
                    mk[n] = mk[n] + (double)this.samp[thread].randAntoniak(this.alpha * this.tau.get(k), this.nmk[m].get(k));
                } else {
                    int n = kk;
                    mk[n] = mk[n] + (double)this.nmk[m].get(k).intValue();
                }
                ++m;
            }
            ++kk;
        }
        this.T = Vectors.sum(mk);
        mk[this.K] = this.gamma;
        double[] tt = this.samp[thread].randDir(mk);
        int kk2 = 0;
        while (kk2 < this.K) {
            int k = this.kactive.get(kk2);
            this.tau.set(k, tt[kk2]);
            ++kk2;
        }
        this.tau.set(this.K, tt[this.K]);
    }

    private void updateHyper() {
        int r = 0;
        while (r < this.R) {
            double eta = this.samp[0].randBeta(this.gamma + 1.0, this.T);
            double bloge = this.bgamma - Math.log(eta);
            double pie = 1.0 / (1.0 + this.T * bloge / (this.agamma + (double)this.K - 1.0));
            int u = this.samp[0].randBernoulli(pie);
            this.gamma = this.samp[0].randGamma(this.agamma + (double)this.K - 1.0 + (double)u, 1.0 / bloge);
            double qs = 0.0;
            double qw = 0.0;
            int m = 0;
            while (m < this.M) {
                qs += (double)this.samp[0].randBernoulli((double)this.w[m].length / ((double)this.w[m].length + this.alpha));
                qw += Math.log(this.samp[0].randBeta(this.alpha + 1.0, this.w[m].length));
                ++m;
            }
            this.alpha = this.samp[0].randGamma(this.aalpha + this.T - qs, 1.0 / (this.balpha - qw));
            ++r;
        }
        int[] ak = (int[])ArrayUtils.asPrimitiveArray(this.nk);
        int[][] akt = new int[this.K][this.V];
        int k = 0;
        while (k < this.K) {
            akt[k] = this.nkt.get(k);
            ++k;
        }
        this.beta = DirichletEstimation.estimateAlphaMap(akt, ak, this.beta, this.abeta, this.bbeta);
    }

    @Override
    public double ppx() {
        double loglik = 0.0;
        double[][] thetaq = new double[this.Mq][this.K];
        int m = 0;
        while (m < this.Mq) {
            int k = 0;
            while (k < this.K) {
                thetaq[m][k] = ((double)this.nmkq[m][k] + this.alpha) / ((double)this.wq[m].length + (double)this.K * this.alpha);
                ++k;
            }
            ++m;
        }
        m = 0;
        while (m < this.Mq) {
            int n = 0;
            while (n < this.wq[m].length) {
                double sum = 0.0;
                int k = 0;
                while (k < this.K) {
                    sum += thetaq[m][k] * this.phi[k][this.wq[m][n]];
                    ++k;
                }
                loglik += Math.log(sum);
                ++n;
            }
            ++m;
        }
        return Math.exp(-loglik / (double)this.Wq);
    }

    public String toString() {
        return String.format("ILDA: M = %d, K = %d, V = %d, alpha = %2.5f, beta = %2.5f, gamma = %2.5f", this.M, this.K, this.V, this.alpha, this.beta, this.gamma);
    }
}

