/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.topics.simple;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.knowceans.util.Vectors;

public class TopicMatrixPanel
extends JPanel {
    public boolean doLog;
    public boolean doSort;
    public boolean doNormalise;
    private static final long serialVersionUID = 1L;
    double[][] matrix = null;
    private int K;
    private double max;
    private int PIX = 20;

    public TopicMatrixPanel(int width, int height, int K, int pix) {
        this("Visual Matrix", width, height, K);
        this.PIX = pix;
    }

    public TopicMatrixPanel(String title, int width, int height, int K) {
        this.K = K;
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(this);
        this.setPreferredSize(new Dimension(width, height));
        frame.setSize(width, height);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char key = e.getKeyChar();
                if (key == '1') {
                    TopicMatrixPanel topicMatrixPanel = TopicMatrixPanel.this;
                    topicMatrixPanel.PIX = topicMatrixPanel.PIX - 1;
                    if (TopicMatrixPanel.this.PIX == 0) {
                        TopicMatrixPanel.this.PIX = 1;
                    }
                }
                if (key == '2') {
                    TopicMatrixPanel topicMatrixPanel = TopicMatrixPanel.this;
                    topicMatrixPanel.PIX = topicMatrixPanel.PIX + 1;
                }
                TopicMatrixPanel.this.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        BufferedImage bufferedImage = new BufferedImage(w, h, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(Color.lightGray);
        g2d.fillRect(0, 0, w, h);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(new Color(150, 150, 150));
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHints(rh);
        if (this.matrix == null) {
            return;
        }
        int xoffset = 10;
        int yoffset = 10;
        int K2 = this.K >> 1;
        int k = 0;
        while (k < this.matrix.length) {
            if (this.matrix[k][0] != Double.NEGATIVE_INFINITY) {
                g2d.setColor(Color.red);
                int i = 0;
                while (i < K2) {
                    int j = 0;
                    while (j < K2) {
                        g2d.drawRect(xoffset, yoffset, this.PIX * K2, this.PIX * K2);
                        float u = 0.0f;
                        try {
                            u = (float)this.matrix[k][i * K2 + j];
                        }
                        catch (Exception e) {
                            System.out.println("k = " + k + " i = " + i + " j = " + j + " matrix size = " + this.matrix.length + "," + this.matrix[0].length);
                        }
                        g2d.setColor(new Color(u, u, u));
                        g2d.fillRect(xoffset + i * this.PIX, yoffset + this.PIX * j, this.PIX, this.PIX);
                        ++j;
                    }
                    ++i;
                }
            }
            if ((xoffset += this.PIX * K2 + 10) + this.PIX * K2 + 10 >= this.getWidth()) {
                yoffset += this.PIX * K2 + 10;
                xoffset = 10;
            }
            ++k;
        }
        g2d = (Graphics2D)g;
        g2d.drawImage(bufferedImage, null, 0, 0);
    }

    public void setTopics(int[][] nkt) {
        if (this.matrix == null) {
            this.matrix = new double[nkt.length][nkt[0].length];
        }
        int k = 0;
        while (k < nkt.length) {
            this.max = 0.0;
            int t = 0;
            while (t < nkt[0].length) {
                this.matrix[k][t] = this.doLog ? Math.log(1 + nkt[k][t]) : (double)nkt[k][t];
                this.max = Math.max(this.matrix[k][t], this.max);
                ++t;
            }
            if (this.doNormalise) {
                double sum = Vectors.sum(this.matrix[k]);
                Vectors.mult(this.matrix[k], 1.0 / sum * 255.0);
            }
            if (this.max == 0.0) {
                this.matrix[k][0] = Double.NEGATIVE_INFINITY;
            } else {
                if (this.doLog) {
                    this.max = Math.log(1.0 + this.max);
                }
                Vectors.mult(this.matrix[k], 1.0 / this.max);
            }
            ++k;
        }
        this.repaint();
    }

    public void setTopics(List<int[]> nkt) {
        if (this.matrix != null && nkt.size() > this.matrix.length) {
            this.matrix = null;
        }
        this.setTopics((int[][])nkt.toArray((T[])new int[0][0]));
    }
}

