/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.topics.simple;

import org.knowceans.corpus.CorpusResolver;
import org.knowceans.corpus.LabelNumCorpus;
import org.knowceans.util.IndexQuickSort;

public class LdaTopics {
    CorpusResolver cr;
    private double[][] phi;
    private double[][] theta;
    private LabelNumCorpus corpus;

    public LdaTopics(String filebase, double[][] theta, double[][] phi) {
        this.cr = new CorpusResolver(filebase);
        this.corpus = new LabelNumCorpus(filebase);
        this.theta = theta;
        this.phi = phi;
    }

    public String printDocument(int m, int morig, int topics, boolean label, boolean author) {
        Object a;
        StringBuffer b = new StringBuffer();
        b.append(String.format("%d: %s\n    id = %d\n", m, this.cr.getDoc(morig), morig));
        if (author) {
            a = this.corpus.getDocLabels(0);
            StringBuffer aa = new StringBuffer();
            int[] nArray = a[morig];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                aa.append(this.cr.getAuthor(i)).append(" ");
                ++n2;
            }
            b.append(String.format("    authors = %s\n", aa.toString()));
        }
        if (label) {
            a = this.corpus.getDocLabels(1);
            b.append(String.format("    cat = %s\n", this.cr.getLabel(a[morig][0])));
        }
        a = IndexQuickSort.sort(this.theta[m]);
        IndexQuickSort.reverse((int[])a);
        int k = 0;
        while (k < Math.min(((int[][])a).length, topics)) {
            int[] kk = a[k];
            b.append(String.format("    %d (%2.5f):%s\n", (int)kk, this.theta[m][kk], this.printTopic((int)kk, 10)));
            ++k;
        }
        return b.toString();
    }

    public String printTopic(int k, int terms) {
        StringBuffer b = new StringBuffer();
        int[] a = IndexQuickSort.sort(this.phi[k]);
        IndexQuickSort.reverse(a);
        int t = 0;
        while (t < Math.min(a.length, terms)) {
            int tt = a[t];
            b.append(String.format(" %d %s (%2.5f)", tt, this.cr.getTerm(tt), this.phi[k][tt]));
            ++t;
        }
        return b.toString();
    }
}

