/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.corpus;

import org.knowceans.corpus.Document;
import org.knowceans.corpus.NumCorpus;
import org.knowceans.util.RandomSamplers;

public class VisCorpus {
    public static NumCorpus generateLdaCorpus(int K, int M, int Nm) {
        NumCorpus nc = new NumCorpus();
        nc.docs = new Document[M];
        int K2 = K >> 1;
        nc.numTerms = K2 * K2;
        nc.numDocs = M;
        nc.numWords = M * Nm;
        double[][] phi = new double[K][nc.numTerms];
        int k = 0;
        while (k < K2) {
            int i = 0;
            while (i < K2) {
                phi[k][i + k * K2] = 1.0 / (double)K2;
                phi[k + K2][i * K2 + k] = 1.0 / (double)K2;
                ++i;
            }
            ++k;
        }
        RandomSamplers samp = new RandomSamplers();
        int m = 0;
        while (m < M) {
            double[] theta = samp.randDir(1.0, K);
            int[] doc = new int[Nm];
            int n = 0;
            while (n < Nm) {
                int z = samp.randMult(theta);
                doc[n] = samp.randMult(phi[z]);
                ++n;
            }
            Document d = new Document();
            d.setWords(doc);
            d.compile();
            nc.docs[m] = d;
            ++m;
        }
        return nc;
    }
}

