/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.corpus;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.knowceans.corpus.ILabelCorpus;
import org.knowceans.corpus.NumCorpus;
import org.knowceans.util.Vectors;

public class LabelNumCorpus
extends NumCorpus
implements ILabelCorpus {
    public static final String[] EXTENSIONS = new String[]{".authors", ".labels", ".vols", ".refs", ".tags", ".years"};
    int[][][] labels;
    int[] labelsW;
    int[] labelsV;
    String dataFilebase = null;

    public LabelNumCorpus() {
        this.init();
    }

    public LabelNumCorpus(String dataFilebase) {
        super(String.valueOf(dataFilebase) + ".corpus");
        this.dataFilebase = dataFilebase;
        this.init();
    }

    public LabelNumCorpus(String dataFilebase, boolean parmode) {
        super(String.valueOf(dataFilebase) + (parmode ? ".par" : "") + ".corpus");
        this.dataFilebase = dataFilebase;
        this.init();
    }

    public LabelNumCorpus(String dataFilebase, int readlimit, boolean parmode) {
        super(String.valueOf(dataFilebase) + (parmode ? ".par" : "") + ".corpus", readlimit);
        this.dataFilebase = dataFilebase;
        this.init();
    }

    public LabelNumCorpus(NumCorpus corp) {
        this.docs = corp.docs;
        this.numDocs = corp.numDocs;
        this.numTerms = corp.numTerms;
        this.numWords = corp.numWords;
        this.init();
    }

    protected void init() {
        this.labels = new int[EXTENSIONS.length][][];
        this.labelsW = new int[EXTENSIONS.length];
        this.labelsV = new int[EXTENSIONS.length];
    }

    @Override
    public int[][] getDocLabels(int kind) {
        if (this.labels[kind] == null) {
            this.readLabels(kind);
        }
        return this.labels[kind];
    }

    public int getLabelsMaxN(int kind) {
        int max = 0;
        int m = 0;
        while (m < this.labels[kind].length) {
            max = max < this.labels[kind][m].length ? this.labels[kind][m].length : max;
            ++m;
        }
        return max;
    }

    @Override
    public int getLabelsW(int kind) {
        return this.labelsW[kind];
    }

    @Override
    public int getLabelsV(int kind) {
        return this.labelsV[kind];
    }

    private void readLabels(int kind) {
        ArrayList<int[]> data = new ArrayList<int[]>();
        int W = 0;
        int V = 0;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(this.dataFilebase) + EXTENSIONS[kind]));
            int j = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) {
                    data.add(new int[0]);
                    continue;
                }
                String[] parts = line.split(" ");
                int[] a = new int[parts.length];
                int i = 0;
                while (i < parts.length) {
                    a[i] = Integer.parseInt(parts[i].trim());
                    if (a[i] >= V) {
                        V = a[i] + 1;
                    }
                    ++i;
                }
                W += a.length;
                data.add(a);
                ++j;
            }
            br.close();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.labels[kind] = (int[][])data.toArray((T[])new int[0][0]);
        this.labelsW[kind] = W;
        this.labelsV[kind] = V;
    }

    @Override
    public void split(int order, int split, Random rand) {
        super.split(order, split, rand);
        int Mtest = this.splitstarts[split + 1] - this.splitstarts[split];
        this.labelsW = new int[EXTENSIONS.length];
        int[][][] trainLabels = new int[EXTENSIONS.length][this.numDocs - Mtest][];
        int[][][] testLabels = new int[EXTENSIONS.length][Mtest][];
        int[] trainLabelsW = new int[EXTENSIONS.length];
        int[] testLabelsW = new int[EXTENSIONS.length];
        int mstart = this.splitstarts[split];
        int type = 0;
        while (type < EXTENSIONS.length) {
            if (this.labels[type] != null) {
                int mtrain = 0;
                int m = 0;
                while (m < this.splitstarts[split]) {
                    trainLabels[type][mtrain] = this.labels[type][this.splitperm[m]];
                    ++mtrain;
                    ++m;
                }
                m = this.splitstarts[split + 1];
                while (m < this.numDocs) {
                    trainLabels[type][mtrain] = this.labels[type][this.splitperm[m]];
                    ++mtrain;
                    ++m;
                }
                m = 0;
                while (m < Mtest) {
                    testLabels[type][m] = this.labels[type][this.splitperm[m + mstart]];
                    int n = type;
                    testLabelsW[n] = testLabelsW[n] + testLabels[type][m].length;
                    ++m;
                }
                trainLabelsW[type] = this.labelsW[type] - testLabelsW[type];
            }
            ++type;
        }
        this.trainCorpus = new LabelNumCorpus((NumCorpus)this.getTrainCorpus());
        this.testCorpus = new LabelNumCorpus((NumCorpus)this.getTestCorpus());
        LabelNumCorpus train = (LabelNumCorpus)this.trainCorpus;
        train.labels = trainLabels;
        train.labelsV = this.labelsV;
        train.labelsW = trainLabelsW;
        LabelNumCorpus test = (LabelNumCorpus)this.testCorpus;
        test.labels = testLabels;
        test.labelsV = this.labelsV;
        test.labelsW = testLabelsW;
    }

    @Override
    public void write(String pathbase) throws IOException {
        super.write(pathbase);
    }

    public static void main(String[] args) {
        LabelNumCorpus nc = new LabelNumCorpus("berry95/berry95");
        nc.getDocLabels(0);
        nc.split(10, 0, new Random());
        System.out.println("train");
        LabelNumCorpus ncc = (LabelNumCorpus)nc.getTrainCorpus();
        System.out.println(ncc);
        int[][] x = ncc.getDocWords(new Random());
        System.out.println(Vectors.print(x));
        System.out.println("labels");
        int[][] a = ncc.getDocLabels(0);
        System.out.println(Vectors.print(a));
        System.out.println("test");
        ncc = (LabelNumCorpus)nc.getTestCorpus();
        System.out.println(ncc);
        x = ncc.getDocWords(new Random());
        System.out.println(Vectors.print(x));
        System.out.println("labels");
        a = ncc.getDocLabels(0);
        System.out.println(Vectors.print(a));
        System.out.println("document mapping");
        System.out.println(Vectors.print(nc.getOrigDocIds()));
    }
}

