/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.corpus;

import java.util.HashMap;
import java.util.Map;
import org.knowceans.util.Vectors;

public class Document {
    protected int[] terms;
    protected int[] counts;
    protected int numTerms;
    protected int numWords;
    int[] parBounds;

    public Document() {
        this.numTerms = 0;
        this.terms = new int[0];
        this.counts = new int[0];
    }

    public Document(int length) {
        this.terms = new int[length];
        this.counts = new int[length];
        this.numTerms = length;
    }

    public Document(Document d) {
        this.terms = Vectors.copy(d.terms);
        this.counts = Vectors.copy(d.counts);
        this.parBounds = Vectors.copy(d.parBounds);
        this.numTerms = d.numTerms;
        this.numWords = d.numWords;
    }

    public void compile() {
        try {
            if (this.counts.length != this.terms.length) {
                throw new Exception("Document inconsistent.");
            }
            this.numTerms = this.counts.length;
            int[] nArray = this.counts;
            int n = this.counts.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                this.numWords += c;
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] getCounts() {
        return this.counts;
    }

    public int getCount(int index) {
        return this.counts[index];
    }

    public void setCount(int index, int count) {
        this.counts[index] = count;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public int getNumWords() {
        return this.numWords;
    }

    public int[] getTerms() {
        return this.terms;
    }

    public int getTerm(int index) {
        return this.terms[index];
    }

    public void setTerm(int index, int term) {
        this.terms[index] = term;
    }

    public void setCounts(int[] is) {
        this.counts = is;
    }

    public void setNumTerms(int i) {
        this.numTerms = i;
    }

    public void setNumWords(int i) {
        this.numWords = i;
    }

    public void setTerms(int[] is) {
        this.terms = is;
    }

    public void setWords(int[] is) {
        if (this.terms == null) {
            this.terms = new int[this.numTerms];
            this.counts = new int[this.numTerms];
        }
        HashMap<Integer, Integer> termfreqs = new HashMap<Integer, Integer>();
        int n = 0;
        while (n < this.numTerms) {
            Integer a = (Integer)termfreqs.get(this.terms[n]);
            if (a == 0) {
                termfreqs.put(this.terms[n], this.counts[n]);
            } else {
                termfreqs.put(this.terms[n], this.counts[n] + a);
            }
            ++n;
        }
        n = 0;
        while (n < is.length) {
            Integer count = (Integer)termfreqs.get(is[n]);
            if (count == null) {
                termfreqs.put(is[n], 1);
            } else {
                termfreqs.put(is[n], count + 1);
            }
            ++n;
        }
        this.terms = new int[termfreqs.size()];
        this.counts = new int[termfreqs.size()];
        n = 0;
        for (Map.Entry tf : termfreqs.entrySet()) {
            this.terms[n] = (Integer)tf.getKey();
            this.counts[n] = (Integer)tf.getValue();
            ++n;
        }
        this.numTerms = this.terms.length;
        this.numWords = Vectors.sum(this.counts);
    }

    public void addDocument(Document d) {
        if (this.parBounds == null) {
            this.parBounds = new int[1];
            this.parBounds[0] = d.numTerms;
            this.terms = d.terms;
            this.counts = d.counts;
            this.numTerms = d.numTerms;
            this.numWords = d.numWords;
        } else {
            this.parBounds = Vectors.concat(this.parBounds, new int[]{this.numTerms + d.numTerms});
            this.terms = Vectors.concat(this.terms, d.terms);
            this.counts = Vectors.concat(this.counts, d.counts);
            this.numTerms += d.numTerms;
            this.numWords += d.numWords;
        }
    }

    public void mergeDocument(Document d) {
        Integer a;
        HashMap<Integer, Integer> termfreqs = new HashMap<Integer, Integer>();
        int n = 0;
        while (n < this.numTerms) {
            a = (Integer)termfreqs.get(this.terms[n]);
            if (a == 0) {
                termfreqs.put(this.terms[n], this.counts[n]);
            } else {
                termfreqs.put(this.terms[n], this.counts[n] + a);
            }
            ++n;
        }
        if (d != null) {
            n = 0;
            while (n < this.numTerms) {
                a = (Integer)termfreqs.get(d.terms[n]);
                if (a == 0) {
                    termfreqs.put(d.terms[n], d.counts[n]);
                } else {
                    termfreqs.put(d.terms[n], d.counts[n] + a);
                }
                ++n;
            }
        }
        this.terms = new int[termfreqs.size()];
        this.counts = new int[termfreqs.size()];
        n = 0;
        for (Map.Entry tf : termfreqs.entrySet()) {
            this.terms[n] = (Integer)tf.getKey();
            this.counts[n] = (Integer)tf.getValue();
            ++n;
        }
        this.numTerms = this.terms.length;
        this.numWords = Vectors.sum(this.counts);
    }

    public int[] getParBounds() {
        return this.parBounds;
    }

    public void setParBounds(int[] parBounds) {
        this.parBounds = parBounds;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Document {numTerms=" + this.numTerms + " numWords=" + this.numWords);
        if (this.parBounds != null) {
            b.append(" numPars=" + this.parBounds.length + "}");
        } else {
            b.append("}");
        }
        return b.toString();
    }
}

