/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.corpus;

import java.util.ArrayList;
import java.util.Random;
import org.knowceans.corpus.NumCorpus;
import org.knowceans.util.ArrayUtils;
import org.knowceans.util.IndexQuickSort;
import org.knowceans.util.Vectors;

public class DisjointDocTerms {
    private int[][] w;
    private int V;

    public static void main(String[] args) {
        int P = 2;
        NumCorpus nc = new NumCorpus("./berry95/berry95.corpus");
        int[][] w = nc.getDocWords(new Random());
        DisjointDocTerms dj = new DisjointDocTerms(w, nc.getNumTerms());
        int[][] mm = dj.getDisjointDocuments(P);
        System.out.println("disjoint document sets");
        int p = 0;
        while (p < P) {
            System.out.println(Vectors.print(mm[p]));
            ++p;
        }
        System.out.println("disjoint term sets");
        int[][] tt = dj.getDisjointTerms(P);
        int p2 = 0;
        while (p2 < P) {
            System.out.println(Vectors.print(tt[p2]));
            ++p2;
        }
        System.out.println("disjoint token sequences");
        int[][][] ww = dj.getDisjointTokens(P);
        int p3 = 0;
        while (p3 < P) {
            System.out.println("corpus " + p3);
            int m = 0;
            while (m < nc.getNumDocs()) {
                System.out.println(Vectors.print(ww[p3][m]));
                ++m;
            }
            ++p3;
        }
    }

    public DisjointDocTerms(int[][] w, int V) {
        this.w = w;
        this.V = V;
    }

    public int[][] getDisjointDocuments(int P) {
        int[][] pm = new int[P][];
        int[] dd = this.alignDocs(P);
        int M = this.w.length;
        int size = M / P;
        int plus = M % P;
        int p = 0;
        while (p < P) {
            pm[p] = new int[size + (p < plus ? 1 : 0)];
            ++p;
        }
        int[] ii = new int[P];
        int m = 0;
        while (m < M) {
            int p2 = dd[m];
            pm[p2][ii[p2]] = m++;
            int n = p2;
            ii[n] = ii[n] + 1;
        }
        return pm;
    }

    public int[][] getDisjointTerms(int P) {
        int[][] qt = new int[P][];
        int size = this.V / P;
        int plus = this.V % P;
        int q = 0;
        while (q < P) {
            qt[q] = new int[size + (q < plus ? 1 : 0)];
            int i = 0;
            while (i < qt[q].length) {
                qt[q][i] = q + i * P;
                ++i;
            }
            ++q;
        }
        return qt;
    }

    public int[][][] getDisjointTokens(int P) {
        int M = this.w.length;
        int[] pt = this.alignTerms(P);
        ArrayList[][] wpm = new ArrayList[P][M];
        int m = 0;
        while (m < M) {
            int q = 0;
            while (q < P) {
                wpm[q][m] = new ArrayList();
                ++q;
            }
            int n = 0;
            while (n < this.w[m].length) {
                wpm[pt[this.w[m][n]]][m].add(n);
                ++n;
            }
            ++m;
        }
        int[][][] pp = new int[P][M][];
        int m2 = 0;
        while (m2 < M) {
            int q = 0;
            while (q < P) {
                pp[q][m2] = wpm[q][m2].size() > 0 ? (int[])ArrayUtils.asPrimitiveArray(wpm[q][m2]) : new int[0];
                ++q;
            }
            ++m2;
        }
        return pp;
    }

    private int[] alignTerms(int P) {
        int[] pt = new int[this.V];
        int t = 0;
        while (t < pt.length) {
            pt[t] = t % P;
            ++t;
        }
        return pt;
    }

    private int[] alignDocs(int P) {
        int M = this.w.length;
        int[] pm = new int[M];
        int[] nm = new int[M];
        int m = 0;
        while (m < M) {
            nm[m] = this.w[m].length;
            ++m;
        }
        int[] idxm = IndexQuickSort.sort(nm);
        IndexQuickSort.reverse(idxm);
        int m2 = 0;
        while (m2 < M) {
            pm[idxm[m2]] = m2 % P;
            ++m2;
        }
        return pm;
    }
}

