/*
 * Decompiled with CFR 0.152.
 */
package org.knowceans.corpus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class CorpusResolver {
    public final String[] EXTENSIONS = new String[]{"docs", "vocab", "authors.key", "labels.key", "vols.key", "docnames"};
    HashMap<String, Integer> termids;
    String[][] data = new String[this.EXTENSIONS.length][];
    String filebase;
    private boolean parmode;

    public static void main(String[] args) {
        CorpusResolver cr = new CorpusResolver("nips/nips");
        System.out.println(cr.getAuthor(2));
        System.out.println(cr.getLabel(20));
        System.out.println(cr.getDoc(501));
        System.out.println(cr.getTerm(1));
        System.out.println(cr.getTermId(cr.getTerm(1)));
    }

    public CorpusResolver(String filebase) {
        this(filebase, false);
    }

    public CorpusResolver(String filebase, boolean parmode) {
        this.parmode = parmode;
        this.filebase = filebase;
        int i = 0;
        while (i < this.EXTENSIONS.length) {
            File f;
            String base = filebase;
            if (parmode && this.EXTENSIONS[i].equals("vocab")) {
                base = String.valueOf(base) + ".par";
            }
            if ((f = new File(String.valueOf(base) + "." + this.EXTENSIONS[i])).exists()) {
                this.data[i] = this.load(f);
            }
            ++i;
        }
    }

    private String[] load(File f) {
        String[] strings = null;
        try {
            ArrayList<String> a = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                int ii = (line = line.trim()).indexOf(61);
                if (ii > -1) {
                    a.add(line.substring(0, ii));
                    continue;
                }
                a.add(line);
            }
            br.close();
            strings = a.toArray(new String[0]);
            return strings;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strings;
    }

    public String getTerm(int t) {
        if (this.data[1] != null) {
            return this.data[1][t];
        }
        return null;
    }

    public int getTermId(String term) {
        if (this.termids == null) {
            this.termids = new HashMap();
            int i = 0;
            while (i < this.data[1].length) {
                this.termids.put(this.data[1][i], i);
                ++i;
            }
        }
        return this.termids.get(term);
    }

    public String getLabel(int i) {
        if (this.data[3] != null) {
            return this.data[3][i];
        }
        return null;
    }

    public String getAuthor(int i) {
        if (this.data[2] != null) {
            return this.data[2][i];
        }
        return null;
    }

    public String getDoc(int i) {
        if (this.data[0] != null) {
            return this.data[0][i];
        }
        return null;
    }

    public String getDocName(int i) {
        if (this.data[5] != null) {
            return this.data[5][i];
        }
        return null;
    }

    public String getVol(int i) {
        if (this.data[4] != null) {
            return this.data[4][i];
        }
        return null;
    }

    public String getLabel(int type, int id) {
        if (type == -1) {
            return this.getTerm(id);
        }
        if (type == 0) {
            return this.getAuthor(id);
        }
        if (type == 1) {
            return this.getLabel(id);
        }
        if (type == 2) {
            return this.getVol(id);
        }
        if (type == 3) {
            return null;
        }
        if (type == -2) {
            return this.getDoc(id);
        }
        return null;
    }

    public int getId(int type, String label) {
        if (type == -1) {
            return this.getTermId(label);
        }
        if (type == 0) {
            return Arrays.asList(this.data[type]).indexOf(label);
        }
        return -1;
    }
}

